/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mappers;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.mappers.ContentTypeMapper;
import org.mockserver.model.BinaryBody;
import org.mockserver.model.Cookie;
import org.mockserver.model.Cookies;
import org.mockserver.model.Header;
import org.mockserver.model.Headers;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.Parameter;
import org.mockserver.model.Parameters;
import org.mockserver.model.StringBody;
import org.mockserver.streams.IOStreamUtils;

public class HttpServletRequestToMockServerRequestDecoder {
    private final ContentTypeMapper contentTypeMapper;
    private final IOStreamUtils ioStreamUtils;

    public HttpServletRequestToMockServerRequestDecoder(MockServerLogger mockServerLogger) {
        this.contentTypeMapper = new ContentTypeMapper(mockServerLogger);
        this.ioStreamUtils = new IOStreamUtils(mockServerLogger);
    }

    public HttpRequest mapHttpServletRequestToMockServerRequest(HttpServletRequest httpServletRequest) {
        HttpRequest request = new HttpRequest();
        this.setMethod(request, httpServletRequest);
        this.setPath(request, httpServletRequest);
        this.setQueryString(request, httpServletRequest);
        this.setBody(request, httpServletRequest);
        this.setHeaders(request, httpServletRequest);
        this.setCookies(request, httpServletRequest);
        request.withKeepAlive(this.isKeepAlive(httpServletRequest));
        request.withSecure(httpServletRequest.isSecure());
        return request;
    }

    private void setMethod(HttpRequest httpRequest, HttpServletRequest httpServletRequest) {
        httpRequest.withMethod(httpServletRequest.getMethod());
    }

    private void setPath(HttpRequest httpRequest, HttpServletRequest httpServletRequest) {
        httpRequest.withPath(httpServletRequest.getPathInfo() != null && httpServletRequest.getContextPath() != null ? httpServletRequest.getPathInfo() : httpServletRequest.getRequestURI());
    }

    private void setQueryString(HttpRequest httpRequest, HttpServletRequest httpServletRequest) {
        Parameters parameters = new Parameters(new Parameter[0]);
        if (StringUtils.isNotEmpty((CharSequence)httpServletRequest.getQueryString())) {
            parameters.withEntries(new QueryStringDecoder("?" + httpServletRequest.getQueryString()).parameters());
        }
        httpRequest.withQueryStringParameters(parameters);
    }

    private void setBody(HttpRequest httpRequest, HttpServletRequest httpServletRequest) {
        byte[] bodyBytes = this.ioStreamUtils.readInputStreamToByteArray((ServletRequest)httpServletRequest);
        if (bodyBytes.length > 0) {
            if (ContentTypeMapper.isBinary(httpServletRequest.getHeader(HttpHeaderNames.CONTENT_TYPE.toString()))) {
                httpRequest.withBody(new BinaryBody(bodyBytes));
            } else {
                Charset requestCharset = this.contentTypeMapper.getCharsetFromContentTypeHeader(httpServletRequest.getHeader(HttpHeaderNames.CONTENT_TYPE.toString()));
                httpRequest.withBody(new StringBody(new String(bodyBytes, requestCharset), ContentTypeMapper.DEFAULT_HTTP_CHARACTER_SET.equals(requestCharset) ? null : requestCharset));
            }
        }
    }

    private void setHeaders(HttpRequest httpRequest, HttpServletRequest httpServletRequest) {
        Headers headers = new Headers(new Header[0]);
        Enumeration headerNames = httpServletRequest.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            ArrayList<String> mappedHeaderValues = new ArrayList<String>();
            Enumeration headerValues = httpServletRequest.getHeaders(headerName);
            while (headerValues.hasMoreElements()) {
                mappedHeaderValues.add((String)headerValues.nextElement());
            }
            headers.withEntry(headerName, mappedHeaderValues);
        }
        httpRequest.withHeaders(headers);
    }

    private void setCookies(HttpRequest httpRequest, HttpServletRequest httpServletRequest) {
        Cookies cookies = new Cookies(new Cookie[0]);
        if (httpServletRequest.getCookies() != null) {
            for (javax.servlet.http.Cookie cookie : httpServletRequest.getCookies()) {
                cookies.withEntry(new Cookie(cookie.getName(), cookie.getValue()));
            }
        }
        httpRequest.withCookies(cookies);
    }

    public boolean isKeepAlive(HttpServletRequest httpServletRequest) {
        String connection = httpServletRequest.getHeader(HttpHeaderNames.CONNECTION.toString());
        if (HttpHeaderValues.CLOSE.contentEqualsIgnoreCase((CharSequence)connection)) {
            return false;
        }
        if (httpServletRequest.getProtocol().equals("HTTP/1.1")) {
            return !HttpHeaderValues.CLOSE.contentEqualsIgnoreCase((CharSequence)connection);
        }
        return HttpHeaderValues.KEEP_ALIVE.contentEqualsIgnoreCase((CharSequence)connection);
    }
}

