/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mock.action;

import java.net.InetSocketAddress;
import java.util.concurrent.CompletableFuture;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;

public class HttpForwardActionResult {
    private final HttpRequest httpRequest;
    private final CompletableFuture<HttpResponse> httpResponse;
    private final HttpResponse overriddenHttpResponse;
    private final InetSocketAddress remoteAddress;

    HttpForwardActionResult(HttpRequest httpRequest, CompletableFuture<HttpResponse> httpResponse, HttpResponse overriddenHttpResponse) {
        this(httpRequest, httpResponse, overriddenHttpResponse, null);
    }

    HttpForwardActionResult(HttpRequest httpRequest, CompletableFuture<HttpResponse> httpResponse, HttpResponse overriddenHttpResponse, InetSocketAddress remoteAddress) {
        this.httpRequest = httpRequest;
        this.httpResponse = httpResponse;
        this.overriddenHttpResponse = overriddenHttpResponse;
        this.remoteAddress = remoteAddress;
    }

    public HttpRequest getHttpRequest() {
        return this.httpRequest;
    }

    public CompletableFuture<HttpResponse> getHttpResponse() {
        if (this.overriddenHttpResponse == null) {
            return this.httpResponse;
        }
        return this.httpResponse.thenApply(response -> {
            if (response != null) {
                return response.update(this.overriddenHttpResponse);
            }
            return null;
        });
    }

    HttpResponse getOverriddenHttpResponse() {
        return this.overriddenHttpResponse;
    }

    public InetSocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }
}

