/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mock.action;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.mockserver.client.NettyHttpClient;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.mock.action.ExpectationForwardCallback;
import org.mockserver.mock.action.HttpForwardAction;
import org.mockserver.mock.action.HttpForwardActionResult;
import org.mockserver.model.HttpClassCallback;
import org.mockserver.model.HttpRequest;
import org.slf4j.event.Level;

public class HttpForwardClassCallbackActionHandler
extends HttpForwardAction {
    public HttpForwardClassCallbackActionHandler(MockServerLogger mockServerLogger, NettyHttpClient httpClient) {
        super(mockServerLogger, httpClient);
    }

    public HttpForwardActionResult handle(HttpClassCallback httpClassCallback, HttpRequest request) {
        return this.invokeCallbackMethod(httpClassCallback, request);
    }

    private ExpectationForwardCallback instantiateCallback(HttpClassCallback httpClassCallback) {
        try {
            Class<?> expectationResponseCallbackClass = Class.forName(httpClassCallback.getCallbackClass());
            if (ExpectationForwardCallback.class.isAssignableFrom(expectationResponseCallbackClass)) {
                Constructor<?> constructor = expectationResponseCallbackClass.getConstructor(new Class[0]);
                return (ExpectationForwardCallback)constructor.newInstance(new Object[0]);
            }
            this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setLogLevel(Level.ERROR).setHttpRequest(null).setMessageFormat(httpClassCallback.getCallbackClass() + " does not implement " + ExpectationForwardCallback.class.getCanonicalName() + " which required for forwarded requests generated from a class callback"));
        }
        catch (ClassNotFoundException e) {
            this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setLogLevel(Level.ERROR).setMessageFormat("ClassNotFoundException - while trying to instantiate ExpectationResponseCallback class \"" + httpClassCallback.getCallbackClass() + "\"").setThrowable(e));
        }
        catch (NoSuchMethodException e) {
            this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setLogLevel(Level.ERROR).setMessageFormat("NoSuchMethodException - while trying to create default constructor on ExpectationResponseCallback class \"" + httpClassCallback.getCallbackClass() + "\"").setThrowable(e));
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setLogLevel(Level.ERROR).setMessageFormat("InvocationTargetException - while trying to execute default constructor on ExpectationResponseCallback class \"" + httpClassCallback.getCallbackClass() + "\"").setThrowable(e));
        }
        return null;
    }

    private HttpForwardActionResult invokeCallbackMethod(HttpClassCallback httpClassCallback, HttpRequest httpRequest) {
        if (httpRequest != null) {
            ExpectationForwardCallback expectationForwardCallback = this.instantiateCallback(httpClassCallback);
            if (expectationForwardCallback != null) {
                try {
                    return this.sendRequest(expectationForwardCallback.handle(httpRequest), null, null);
                }
                catch (Throwable throwable) {
                    this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setLogLevel(Level.ERROR).setHttpRequest(httpRequest).setMessageFormat(httpClassCallback.getCallbackClass() + " throw exception while executing handle callback method - " + throwable.getMessage()).setThrowable(throwable));
                    return this.notFoundFuture(httpRequest);
                }
            }
            return this.notFoundFuture(httpRequest);
        }
        return this.notFoundFuture(httpRequest);
    }
}

