/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.model;

import org.mockserver.model.Body;
import org.mockserver.model.BodyWithContentType;
import org.mockserver.model.MediaType;
import org.mockserver.serialization.Base64Converter;

public class BinaryBody
extends BodyWithContentType<byte[]> {
    private final byte[] bytes;
    private final Base64Converter base64Converter = new Base64Converter();

    public BinaryBody(byte[] bytes) {
        this(bytes, null);
    }

    public BinaryBody(byte[] bytes, MediaType contentType) {
        super(Body.Type.BINARY, contentType);
        this.bytes = bytes;
    }

    public static BinaryBody binary(byte[] body) {
        return new BinaryBody(body);
    }

    public static BinaryBody binary(byte[] body, MediaType contentType) {
        return new BinaryBody(body, contentType);
    }

    public byte[] getValue() {
        return this.bytes;
    }

    @Override
    public byte[] getRawBytes() {
        return this.bytes;
    }

    @Override
    public String toString() {
        return this.bytes != null ? this.base64Converter.bytesToBase64String(this.bytes) : null;
    }
}

