/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.socket.tls;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Date;
import java.util.Random;
import java.util.UUID;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.bc.BcX509ExtensionUtils;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.util.IPAddress;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.file.FileReader;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.slf4j.event.Level;

public class KeyAndCertificateFactory {
    private final MockServerLogger mockServerLogger;
    private static final String PROVIDER_NAME = "BC";
    private static final String SIGNATURE_ALGORITHM = "SHA256WithRSAEncryption";
    private static final String KEY_GENERATION_ALGORITHM = "RSA";
    private static final int ROOT_KEYSIZE = 2048;
    private static final int FAKE_KEYSIZE = 2048;
    private static final Date NOT_BEFORE = new Date(System.currentTimeMillis() - 31536000000L);
    private static final Date NOT_AFTER = new Date(System.currentTimeMillis() + 3153600000000L);
    private String mockServerCertificatePEMFile;
    private String mockServerPrivateKeyPEMFile;

    KeyAndCertificateFactory(MockServerLogger mockServerLogger) {
        this.mockServerLogger = mockServerLogger;
    }

    public static void addSubjectAlternativeName(String host) {
        if (host != null) {
            String hostWithoutPort = StringUtils.substringBefore((String)host, (String)":");
            if (IPAddress.isValid((String)hostWithoutPort)) {
                ConfigurationProperties.addSslSubjectAlternativeNameIps(hostWithoutPort);
            } else {
                ConfigurationProperties.addSslSubjectAlternativeNameDomains(hostWithoutPort);
            }
        }
    }

    private static SubjectKeyIdentifier createSubjectKeyIdentifier(Key key) throws IOException {
        try (ASN1InputStream is = new ASN1InputStream((InputStream)new ByteArrayInputStream(key.getEncoded()));){
            ASN1Sequence seq = (ASN1Sequence)is.readObject();
            SubjectPublicKeyInfo info = SubjectPublicKeyInfo.getInstance((Object)seq);
            SubjectKeyIdentifier subjectKeyIdentifier = new BcX509ExtensionUtils().createSubjectKeyIdentifier(info);
            return subjectKeyIdentifier;
        }
    }

    private static X509Certificate signCertificate(X509v3CertificateBuilder certificateBuilder, PrivateKey signedWithPrivateKey) throws OperatorCreationException, CertificateException {
        ContentSigner signer = new JcaContentSignerBuilder(SIGNATURE_ALGORITHM).setProvider(PROVIDER_NAME).build(signedWithPrivateKey);
        return new JcaX509CertificateConverter().setProvider(PROVIDER_NAME).getCertificate(certificateBuilder.build(signer));
    }

    public static void main(String[] args) throws Exception {
        new KeyAndCertificateFactory(new MockServerLogger()).buildAndSaveCertificateAuthorityCertificates();
    }

    private KeyPair generateKeyPair(int keySize) throws Exception {
        KeyPairGenerator generator = KeyPairGenerator.getInstance(KEY_GENERATION_ALGORITHM, PROVIDER_NAME);
        generator.initialize(keySize, new SecureRandom());
        return generator.generateKeyPair();
    }

    private X509Certificate createCACert(PublicKey publicKey, PrivateKey privateKey) throws Exception {
        X500Name issuerName = new X500Name("CN=www.mockserver.com, O=MockServer, L=London, ST=England, C=UK");
        BigInteger serial = BigInteger.valueOf(new Random().nextInt(Integer.MAX_VALUE));
        JcaX509v3CertificateBuilder builder = new JcaX509v3CertificateBuilder(issuerName, serial, NOT_BEFORE, NOT_AFTER, issuerName, publicKey);
        builder.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)KeyAndCertificateFactory.createSubjectKeyIdentifier(publicKey));
        builder.addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(true));
        KeyUsage usage = new KeyUsage(182);
        builder.addExtension(Extension.keyUsage, false, (ASN1Encodable)usage);
        ASN1EncodableVector purposes = new ASN1EncodableVector();
        purposes.add((ASN1Encodable)KeyPurposeId.id_kp_serverAuth);
        purposes.add((ASN1Encodable)KeyPurposeId.id_kp_clientAuth);
        purposes.add((ASN1Encodable)KeyPurposeId.anyExtendedKeyUsage);
        builder.addExtension(Extension.extendedKeyUsage, false, (ASN1Encodable)new DERSequence(purposes));
        X509Certificate cert = KeyAndCertificateFactory.signCertificate((X509v3CertificateBuilder)builder, privateKey);
        cert.checkValidity(new Date());
        cert.verify(publicKey);
        return cert;
    }

    private X509Certificate createCASignedCert(PublicKey publicKey, X509Certificate certificateAuthorityCert, PrivateKey certificateAuthorityPrivateKey, PublicKey certificateAuthorityPublicKey, String domain, String[] subjectAlternativeNameDomains, String[] subjectAlternativeNameIps) throws Exception {
        X500Name issuer = new X509CertificateHolder(certificateAuthorityCert.getEncoded()).getSubject();
        X500Name subject = new X500Name("CN=" + domain + ", O=MockServer, L=London, ST=England, C=UK");
        BigInteger serial = BigInteger.valueOf(new Random().nextInt(Integer.MAX_VALUE));
        JcaX509v3CertificateBuilder builder = new JcaX509v3CertificateBuilder(issuer, serial, NOT_BEFORE, NOT_AFTER, subject, publicKey);
        builder.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)KeyAndCertificateFactory.createSubjectKeyIdentifier(publicKey));
        builder.addExtension(Extension.basicConstraints, false, (ASN1Encodable)new BasicConstraints(false));
        ArrayList<GeneralName> subjectAlternativeNames = new ArrayList<GeneralName>();
        if (subjectAlternativeNameDomains != null) {
            subjectAlternativeNames.add(new GeneralName(2, domain));
            for (String subjectAlternativeNameDomain : subjectAlternativeNameDomains) {
                subjectAlternativeNames.add(new GeneralName(2, subjectAlternativeNameDomain));
            }
        }
        if (subjectAlternativeNameIps != null) {
            for (String subjectAlternativeNameIp : subjectAlternativeNameIps) {
                if (!IPAddress.isValidIPv6WithNetmask((String)subjectAlternativeNameIp) && !IPAddress.isValidIPv6((String)subjectAlternativeNameIp) && !IPAddress.isValidIPv4WithNetmask((String)subjectAlternativeNameIp) && !IPAddress.isValidIPv4((String)subjectAlternativeNameIp)) continue;
                subjectAlternativeNames.add(new GeneralName(7, subjectAlternativeNameIp));
            }
        }
        if (subjectAlternativeNames.size() > 0) {
            DERSequence subjectAlternativeNamesExtension = new DERSequence(subjectAlternativeNames.toArray(new ASN1Encodable[0]));
            builder.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)subjectAlternativeNamesExtension);
        }
        X509Certificate cert = KeyAndCertificateFactory.signCertificate((X509v3CertificateBuilder)builder, certificateAuthorityPrivateKey);
        cert.checkValidity(new Date());
        cert.verify(certificateAuthorityPublicKey);
        return cert;
    }

    private synchronized void buildAndSaveCertificateAuthorityCertificates() throws Exception {
        KeyPair caKeyPair = this.generateKeyPair(2048);
        this.saveCertificateAsPEMFile(this.createCACert(caKeyPair.getPublic(), caKeyPair.getPrivate()), "CertificateAuthorityCertificate.pem", false, "X509 key");
        this.saveCertificateAsPEMFile(caKeyPair.getPublic(), "CertificateAuthorityPublicKey.pem", false, "public key");
        this.saveCertificateAsPEMFile(caKeyPair.getPrivate(), "CertificateAuthorityPrivateKey.pem", false, "private key");
    }

    synchronized void buildAndSaveCertificates() {
        try {
            KeyPair keyPair = this.generateKeyPair(2048);
            PrivateKey mockServerPrivateKey = keyPair.getPrivate();
            PublicKey mockServerPublicKey = keyPair.getPublic();
            RSAPrivateKey caPrivateKey = this.mockServerCertificateAuthorityPrivateKey();
            X509Certificate caCert = this.mockServerCertificateAuthorityX509Certificate();
            X509Certificate mockServerCert = this.createCASignedCert(mockServerPublicKey, caCert, caPrivateKey, caCert.getPublicKey(), ConfigurationProperties.sslCertificateDomainName(), ConfigurationProperties.sslSubjectAlternativeNameDomains(), ConfigurationProperties.sslSubjectAlternativeNameIps());
            String randomUUID = UUID.randomUUID().toString();
            this.mockServerCertificatePEMFile = this.saveCertificateAsPEMFile(mockServerCert, "MockServerCertificate" + randomUUID + ".pem", true, "X509 key");
            this.mockServerPrivateKeyPEMFile = this.saveCertificateAsPEMFile(mockServerPrivateKey, "MockServerPrivateKey" + randomUUID + ".pem", true, "private key");
        }
        catch (Exception e) {
            this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setLogLevel(Level.ERROR).setMessageFormat("Error while refreshing certificates").setThrowable(e));
        }
    }

    private String saveCertificateAsPEMFile(Object x509Certificate, String filename, boolean deleteOnExit, String type) throws IOException {
        File pemFile;
        if (StringUtils.isNotBlank((CharSequence)ConfigurationProperties.directoryToSaveDynamicSSLCertificate()) && new File(ConfigurationProperties.directoryToSaveDynamicSSLCertificate()).exists()) {
            boolean createFile;
            boolean deletedFile;
            pemFile = new File(new File(ConfigurationProperties.directoryToSaveDynamicSSLCertificate()), filename);
            if (pemFile.exists() && !(deletedFile = pemFile.delete())) {
                this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.WARN).setLogLevel(Level.WARN).setMessageFormat("Failed to delete dynamic TLS certificate " + type + " PEM file at " + pemFile.getAbsolutePath() + " prior to creating new version"));
            }
            if (!(createFile = pemFile.createNewFile())) {
                this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.WARN).setLogLevel(Level.WARN).setMessageFormat("Failed to created dynamic TLS certificate " + type + " PEM file at " + pemFile.getAbsolutePath()));
            }
        } else {
            pemFile = File.createTempFile(filename, null);
        }
        this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.DEBUG).setLogLevel(Level.DEBUG).setMessageFormat("Created dynamic TLS certificate " + type + " PEM file at " + pemFile.getAbsolutePath()));
        try (FileWriter pemfileWriter = new FileWriter(pemFile);
             JcaPEMWriter jcaPEMWriter = new JcaPEMWriter((Writer)pemfileWriter);){
            jcaPEMWriter.writeObject(x509Certificate);
        }
        if (deleteOnExit) {
            pemFile.deleteOnExit();
        }
        return pemFile.getAbsolutePath();
    }

    PrivateKey mockServerPrivateKey() {
        return this.loadPrivateKeyFromPEMFile(this.mockServerPrivateKeyPEMFile);
    }

    X509Certificate mockServerX509Certificate() {
        return this.loadX509FromPEMFile(this.mockServerCertificatePEMFile);
    }

    boolean mockServerX509CertificateCreated() {
        return this.validX509PEMFileExists(this.mockServerCertificatePEMFile);
    }

    X509Certificate mockServerCertificateAuthorityX509Certificate() {
        return this.loadX509FromPEMFile(ConfigurationProperties.certificateAuthorityCertificate());
    }

    private RSAPrivateKey mockServerCertificateAuthorityPrivateKey() {
        return this.loadPrivateKeyFromPEMFile(ConfigurationProperties.certificateAuthorityPrivateKey());
    }

    private RSAPrivateKey loadPrivateKeyFromPEMFile(String filename) {
        try {
            String publicKeyFile = FileReader.readFileFromClassPathOrPath(filename);
            byte[] publicKeyBytes = DatatypeConverter.parseBase64Binary((String)publicKeyFile.replace("-----BEGIN RSA PRIVATE KEY-----", "").replace("-----END RSA PRIVATE KEY-----", ""));
            return (RSAPrivateKey)KeyFactory.getInstance(KEY_GENERATION_ALGORITHM).generatePrivate(new PKCS8EncodedKeySpec(publicKeyBytes));
        }
        catch (Exception e) {
            throw new RuntimeException("Exception reading private key from PEM file", e);
        }
    }

    private X509Certificate loadX509FromPEMFile(String filename) {
        try {
            return (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(FileReader.openStreamToFileFromClassPathOrPath(filename));
        }
        catch (Exception e) {
            throw new RuntimeException("Exception reading X509 from PEM file", e);
        }
    }

    private boolean validX509PEMFileExists(String filename) {
        try {
            return CertificateFactory.getInstance("X.509").generateCertificate(FileReader.openStreamToFileFromClassPathOrPath(filename)) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

