/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.validator.jsonschema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jsonschema.core.report.ProcessingMessage;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import com.github.fge.jsonschema.main.JsonValidator;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.character.Character;
import org.mockserver.file.FileReader;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.model.ObjectWithReflectiveEqualsHashCodeToString;
import org.mockserver.serialization.ObjectMapperFactory;
import org.mockserver.validator.Validator;
import org.slf4j.event.Level;

public class JsonSchemaValidator
extends ObjectWithReflectiveEqualsHashCodeToString
implements Validator<String> {
    private static final Map<String, String> schemaCache = new ConcurrentHashMap<String, String>();
    private final MockServerLogger mockServerLogger;
    private final String schema;
    private final JsonValidator validator = JsonSchemaFactory.byDefault().getValidator();
    private ObjectMapper objectMapper = ObjectMapperFactory.createObjectMapper(new JsonSerializer[0]);

    public JsonSchemaValidator(MockServerLogger mockServerLogger, String schema) {
        this.mockServerLogger = mockServerLogger;
        if (schema.trim().endsWith(".json")) {
            this.schema = FileReader.readFileFromClassPathOrPath(schema);
        } else if (schema.trim().endsWith("}")) {
            this.schema = schema;
        } else {
            throw new IllegalArgumentException("Schema must either be a path reference to a *.json file or a json string");
        }
    }

    public JsonSchemaValidator(MockServerLogger mockServerLogger, String routePath, String mainSchemeFile, String ... referenceFiles) {
        this.mockServerLogger = mockServerLogger;
        if (!schemaCache.containsKey(mainSchemeFile)) {
            schemaCache.put(mainSchemeFile, this.addReferencesIntoSchema(routePath, mainSchemeFile, referenceFiles));
        }
        this.schema = schemaCache.get(mainSchemeFile);
    }

    public String getSchema() {
        return this.schema;
    }

    private String addReferencesIntoSchema(String routePath, String mainSchemeFile, String ... referenceFiles) {
        String combinedSchema = "";
        try {
            ObjectMapper objectMapper = ObjectMapperFactory.createObjectMapper(new JsonSerializer[0]);
            JsonNode jsonSchema = objectMapper.readTree(FileReader.readFileFromClassPathOrPath(routePath + mainSchemeFile + ".json"));
            JsonNode definitions = jsonSchema.get("definitions");
            if (definitions instanceof ObjectNode) {
                for (String definitionName : referenceFiles) {
                    ((ObjectNode)definitions).set(definitionName, objectMapper.readTree(FileReader.readFileFromClassPathOrPath(routePath + definitionName + ".json")));
                }
            }
            combinedSchema = ObjectMapperFactory.createObjectMapper(new JsonSerializer[0]).writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonSchema);
        }
        catch (Exception e) {
            this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setLogLevel(Level.ERROR).setMessageFormat("Exception loading JSON Schema for Exceptions").setThrowable(e));
        }
        return combinedSchema;
    }

    @Override
    public String isValid(String json) {
        String validationResult = "";
        if (StringUtils.isNotBlank((CharSequence)json)) {
            try {
                ProcessingReport processingReport = this.validator.validate(this.objectMapper.readTree(this.schema), this.objectMapper.readTree(json), true);
                if (!processingReport.isSuccess()) {
                    validationResult = this.formatProcessingReport(processingReport);
                }
            }
            catch (Exception e) {
                this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setLogLevel(Level.ERROR).setMessageFormat("Exception validating JSON").setThrowable(e));
                return e.getClass().getSimpleName() + " - " + e.getMessage();
            }
        }
        return validationResult;
    }

    private String formatProcessingReport(ProcessingReport validate) {
        ArrayList<String> validationErrors = new ArrayList<String>();
        for (ProcessingMessage processingMessage : validate) {
            String fieldPointer = "";
            if (processingMessage.asJson().get("instance") != null && processingMessage.asJson().get("instance").get("pointer") != null) {
                fieldPointer = String.valueOf(processingMessage.asJson().get("instance").get("pointer")).replaceAll("\"", "");
            }
            String schemaPointer = "";
            if (processingMessage.asJson().get("schema") != null && processingMessage.asJson().get("schema").get("pointer") != null) {
                schemaPointer = String.valueOf(processingMessage.asJson().get("schema").get("pointer"));
            }
            if (fieldPointer.endsWith("/headers")) {
                validationErrors.add("for field \"" + fieldPointer + "\" only one of the following example formats is allowed: " + Character.NEW_LINE + Character.NEW_LINE + "    \"" + fieldPointer + "\" : {" + Character.NEW_LINE + "        \"exampleHeaderName\" : [ \"exampleHeaderValue\" ]" + Character.NEW_LINE + "        \"exampleMultiValuedHeaderName\" : [ \"exampleHeaderValueOne\", \"exampleHeaderValueTwo\" ]" + Character.NEW_LINE + "    }" + Character.NEW_LINE + Character.NEW_LINE + "   or:" + Character.NEW_LINE + Character.NEW_LINE + "    \"" + fieldPointer + "\" : [" + Character.NEW_LINE + "        {" + Character.NEW_LINE + "            \"name\" : \"exampleHeaderName\"," + Character.NEW_LINE + "            \"values\" : [ \"exampleHeaderValue\" ]" + Character.NEW_LINE + "        }," + Character.NEW_LINE + "        {" + Character.NEW_LINE + "            \"name\" : \"exampleMultiValuedHeaderName\"," + Character.NEW_LINE + "            \"values\" : [ \"exampleHeaderValueOne\", \"exampleHeaderValueTwo\" ]" + Character.NEW_LINE + "        }" + Character.NEW_LINE + "    ]");
                continue;
            }
            if (fieldPointer.endsWith("/queryStringParameters")) {
                validationErrors.add("for field \"" + fieldPointer + "\" only one of the following example formats is allowed: " + Character.NEW_LINE + Character.NEW_LINE + "    \"" + fieldPointer + "\" : {" + Character.NEW_LINE + "        \"exampleParameterName\" : [ \"exampleParameterValue\" ]" + Character.NEW_LINE + "        \"exampleMultiValuedParameterName\" : [ \"exampleParameterValueOne\", \"exampleParameterValueTwo\" ]" + Character.NEW_LINE + "    }" + Character.NEW_LINE + Character.NEW_LINE + "   or:" + Character.NEW_LINE + Character.NEW_LINE + "    \"" + fieldPointer + "\" : [" + Character.NEW_LINE + "        {" + Character.NEW_LINE + "            \"name\" : \"exampleParameterName\"," + Character.NEW_LINE + "            \"values\" : [ \"exampleParameterValue\" ]" + Character.NEW_LINE + "        }," + Character.NEW_LINE + "        {" + Character.NEW_LINE + "            \"name\" : \"exampleMultiValuedParameterName\"," + Character.NEW_LINE + "            \"values\" : [ \"exampleParameterValueOne\", \"exampleParameterValueTwo\" ]" + Character.NEW_LINE + "        }" + Character.NEW_LINE + "    ]");
                continue;
            }
            if (fieldPointer.endsWith("/cookies")) {
                validationErrors.add("for field \"" + fieldPointer + "\" only one of the following example formats is allowed: " + Character.NEW_LINE + Character.NEW_LINE + "    \"" + fieldPointer + "\" : {" + Character.NEW_LINE + "        \"exampleCookieNameOne\" : \"exampleCookieValueOne\"" + Character.NEW_LINE + "        \"exampleCookieNameTwo\" : \"exampleCookieValueTwo\"" + Character.NEW_LINE + "    }" + Character.NEW_LINE + Character.NEW_LINE + "   or:" + Character.NEW_LINE + Character.NEW_LINE + "    \"" + fieldPointer + "\" : [" + Character.NEW_LINE + "        {" + Character.NEW_LINE + "            \"name\" : \"exampleCookieNameOne\"," + Character.NEW_LINE + "            \"values\" : \"exampleCookieValueOne\"" + Character.NEW_LINE + "        }," + Character.NEW_LINE + "        {" + Character.NEW_LINE + "            \"name\" : \"exampleCookieNameTwo\"," + Character.NEW_LINE + "            \"values\" : \"exampleCookieValueTwo\"" + Character.NEW_LINE + "        }" + Character.NEW_LINE + "    ]");
                continue;
            }
            if (fieldPointer.endsWith("/body") && !schemaPointer.contains("bodyWithContentType")) {
                validationErrors.add("for field \"" + fieldPointer + "\" a plain string, JSON object or one of the following example bodies must be specified " + Character.NEW_LINE + "   {" + Character.NEW_LINE + "     \"not\": false," + Character.NEW_LINE + "     \"type\": \"BINARY\"," + Character.NEW_LINE + "     \"base64Bytes\": \"\"," + Character.NEW_LINE + "     \"contentType\": \"\"" + Character.NEW_LINE + "   }, " + Character.NEW_LINE + "   {" + Character.NEW_LINE + "     \"not\": false," + Character.NEW_LINE + "     \"type\": \"JSON\"," + Character.NEW_LINE + "     \"json\": \"\"," + Character.NEW_LINE + "     \"contentType\": \"\"," + Character.NEW_LINE + "     \"matchType\": \"ONLY_MATCHING_FIELDS\"" + Character.NEW_LINE + "   }," + Character.NEW_LINE + "   {" + Character.NEW_LINE + "     \"not\": false," + Character.NEW_LINE + "     \"type\": \"JSON_SCHEMA\"," + Character.NEW_LINE + "     \"jsonSchema\": \"\"" + Character.NEW_LINE + "   }," + Character.NEW_LINE + "   {" + Character.NEW_LINE + "     \"not\": false," + Character.NEW_LINE + "     \"type\": \"JSON_PATH\"," + Character.NEW_LINE + "     \"jsonPath\": \"\"" + Character.NEW_LINE + "   }," + Character.NEW_LINE + "   {" + Character.NEW_LINE + "     \"not\": false," + Character.NEW_LINE + "     \"type\": \"PARAMETERS\"," + Character.NEW_LINE + "     \"parameters\": {\"name\": \"value\"}" + Character.NEW_LINE + "   }," + Character.NEW_LINE + "   {" + Character.NEW_LINE + "     \"not\": false," + Character.NEW_LINE + "     \"type\": \"REGEX\"," + Character.NEW_LINE + "     \"regex\": \"\"" + Character.NEW_LINE + "   }," + Character.NEW_LINE + "   {" + Character.NEW_LINE + "     \"not\": false," + Character.NEW_LINE + "     \"type\": \"STRING\"," + Character.NEW_LINE + "     \"string\": \"\"" + Character.NEW_LINE + "   }," + Character.NEW_LINE + "   {" + Character.NEW_LINE + "     \"not\": false," + Character.NEW_LINE + "     \"type\": \"XML\"," + Character.NEW_LINE + "     \"xml\": \"\"," + Character.NEW_LINE + "     \"contentType\": \"\"" + Character.NEW_LINE + "   }," + Character.NEW_LINE + "   {" + Character.NEW_LINE + "     \"not\": false," + Character.NEW_LINE + "     \"type\": \"XML_SCHEMA\"," + Character.NEW_LINE + "     \"xmlSchema\": \"\"" + Character.NEW_LINE + "   }," + Character.NEW_LINE + "   {" + Character.NEW_LINE + "     \"not\": false," + Character.NEW_LINE + "     \"type\": \"XPATH\"," + Character.NEW_LINE + "     \"xpath\": \"\"" + Character.NEW_LINE + "   }");
                continue;
            }
            if (fieldPointer.endsWith("/body") && schemaPointer.contains("bodyWithContentType")) {
                validationErrors.add("for field \"" + fieldPointer + "\" a plain string, JSON object or one of the following example bodies must be specified " + Character.NEW_LINE + "   {" + Character.NEW_LINE + "     \"type\": \"BINARY\"," + Character.NEW_LINE + "     \"base64Bytes\": \"\"," + Character.NEW_LINE + "     \"contentType\": \"\"" + Character.NEW_LINE + "   }, " + Character.NEW_LINE + "   {" + Character.NEW_LINE + "     \"type\": \"JSON\"," + Character.NEW_LINE + "     \"json\": \"\"," + Character.NEW_LINE + "     \"contentType\": \"\"" + Character.NEW_LINE + "   }," + Character.NEW_LINE + "   {" + Character.NEW_LINE + "     \"type\": \"PARAMETERS\"," + Character.NEW_LINE + "     \"parameters\": {\"name\": \"value\"}" + Character.NEW_LINE + "   }," + Character.NEW_LINE + "   {" + Character.NEW_LINE + "     \"type\": \"STRING\"," + Character.NEW_LINE + "     \"string\": \"\"" + Character.NEW_LINE + "   }," + Character.NEW_LINE + "   {" + Character.NEW_LINE + "     \"type\": \"XML\"," + Character.NEW_LINE + "     \"xml\": \"\"," + Character.NEW_LINE + "     \"contentType\": \"\"" + Character.NEW_LINE + "   }");
                continue;
            }
            if (String.valueOf(processingMessage.asJson().get("keyword")).equals("\"oneOf\"")) {
                StringBuilder oneOfErrorMessage = new StringBuilder("oneOf of the following must be specified ");
                if (fieldPointer.isEmpty()) {
                    oneOfErrorMessage.append(Arrays.asList("\"httpResponse\"", "\"httpResponseTemplate\"", "\"httpResponseObjectCallback\"", "\"httpResponseClassCallback\"", "\"httpForward\"", "\"httpForwardTemplate\"", "\"httpForwardObjectCallback\"", "\"httpForwardClassCallback\"", "\"httpOverrideForwardedRequest\"", "\"httpError\""));
                } else {
                    for (JsonNode jsonNode : processingMessage.asJson().get("reports")) {
                        if (jsonNode.get(0) == null || jsonNode.get(0).get("required") == null || jsonNode.get(0).get("required").get(0) == null) continue;
                        oneOfErrorMessage.append(jsonNode.get(0).get("required").get(0)).append(" ");
                    }
                }
                oneOfErrorMessage.append(" but ").append(processingMessage.asJson().get("matched")).append(" found");
                validationErrors.add(oneOfErrorMessage.toString() + (fieldPointer.isEmpty() ? "" : " for field \"" + fieldPointer + "\""));
                continue;
            }
            if (fieldPointer.endsWith("/times") && processingMessage.toString().contains("has properties which are not allowed by the schema") && String.valueOf(processingMessage.asJson().get("schema")).contains("verificationTimes")) {
                validationErrors.add(processingMessage.getMessage() + " for field \"" + fieldPointer + "\", allowed fields are [\"atLeast\", \"atMost\"]");
                continue;
            }
            validationErrors.add(processingMessage.getMessage() + (fieldPointer.isEmpty() ? "" : " for field \"" + fieldPointer + "\""));
        }
        return validationErrors.size() + " error" + (validationErrors.size() > 1 ? "s" : "") + ":" + Character.NEW_LINE + " - " + Joiner.on((String)(Character.NEW_LINE + " - ")).join(validationErrors);
    }
}

