/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.websocket;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URISyntaxException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import javax.net.ssl.SSLException;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.mock.action.ExpectationCallback;
import org.mockserver.model.HttpObject;
import org.mockserver.model.HttpRequest;
import org.mockserver.serialization.WebSocketMessageSerializer;
import org.mockserver.serialization.model.WebSocketClientIdDTO;
import org.mockserver.serialization.model.WebSocketErrorDTO;
import org.mockserver.websocket.WebSocketClientHandler;
import org.mockserver.websocket.WebSocketException;
import org.slf4j.event.Level;

public class WebSocketClient<T extends HttpObject> {
    static final AttributeKey<CompletableFuture<String>> REGISTRATION_FUTURE = AttributeKey.valueOf((String)"REGISTRATION_FUTURE");
    private final MockServerLogger mockServerLogger;
    private Channel channel;
    private WebSocketMessageSerializer webSocketMessageSerializer;
    private ExpectationCallback<T> expectationCallback;
    private boolean isStopped = false;

    public WebSocketClient(MockServerLogger mockServerLogger) {
        this.mockServerLogger = mockServerLogger;
        this.webSocketMessageSerializer = new WebSocketMessageSerializer(mockServerLogger);
    }

    private Future<String> register(EventLoopGroup eventLoopGroup, final InetSocketAddress serverAddress, final String contextPath, final boolean isSecure) {
        CompletableFuture<String> registrationFuture = new CompletableFuture<String>();
        try {
            ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(eventLoopGroup)).channel(NioSocketChannel.class)).attr(REGISTRATION_FUTURE, registrationFuture)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) throws URISyntaxException {
                    if (isSecure) {
                        try {
                            ch.pipeline().addLast(new ChannelHandler[]{SslContextBuilder.forClient().sslProvider(SslProvider.JDK).trustManager(InsecureTrustManagerFactory.INSTANCE).build().newHandler(ch.alloc(), serverAddress.getHostName(), serverAddress.getPort())});
                        }
                        catch (SSLException e) {
                            throw new WebSocketException("Exception when configuring SSL Handler", e);
                        }
                    }
                    ch.pipeline().addLast(new ChannelHandler[]{new HttpClientCodec(), new HttpObjectAggregator(Integer.MAX_VALUE), new WebSocketClientHandler(WebSocketClient.this.mockServerLogger, serverAddress, contextPath, WebSocketClient.this)});
                }
            })).connect((SocketAddress)serverAddress).addListener((GenericFutureListener)((ChannelFutureListener)connectChannelFuture -> {
                this.channel = connectChannelFuture.channel();
                this.channel.closeFuture().addListener((GenericFutureListener)((ChannelFutureListener)closeChannelFuture -> {
                    if (!this.isStopped) {
                        this.register(eventLoopGroup, serverAddress, contextPath, isSecure);
                    }
                }));
            }));
        }
        catch (Exception e) {
            registrationFuture.completeExceptionally(new WebSocketException("Exception while starting web socket client", e));
        }
        return registrationFuture;
    }

    void receivedTextWebSocketFrame(TextWebSocketFrame textWebSocketFrame) {
        try {
            Object deserializedMessage = this.webSocketMessageSerializer.deserialize(textWebSocketFrame.text());
            if (deserializedMessage instanceof HttpRequest) {
                HttpRequest httpRequest = (HttpRequest)deserializedMessage;
                String webSocketCorrelationId = httpRequest.getFirstHeader("WebSocketCorrelationId");
                if (this.expectationCallback != null) {
                    try {
                        T result = this.expectationCallback.handle(httpRequest);
                        result.withHeader("WebSocketCorrelationId", webSocketCorrelationId);
                        this.channel.writeAndFlush((Object)new TextWebSocketFrame(this.webSocketMessageSerializer.serialize(result)));
                    }
                    catch (Throwable throwable) {
                        this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setLogLevel(Level.ERROR).setHttpRequest(httpRequest).setMessageFormat("Exception thrown while handling callback - " + throwable.getMessage()).setThrowable(throwable));
                        this.channel.writeAndFlush((Object)new TextWebSocketFrame(this.webSocketMessageSerializer.serialize(new WebSocketErrorDTO().setMessage(throwable.getMessage()).setWebSocketCorrelationId(webSocketCorrelationId))));
                    }
                }
            } else if (!(deserializedMessage instanceof WebSocketClientIdDTO)) {
                throw new WebSocketException("Unsupported web socket message " + deserializedMessage);
            }
        }
        catch (Exception e) {
            throw new WebSocketException("Exception while receiving web socket message", e);
        }
    }

    public void stopClient() {
        this.isStopped = true;
        try {
            if (this.channel != null && this.channel.isOpen()) {
                this.channel.close().sync();
                this.channel = null;
            }
        }
        catch (InterruptedException e) {
            throw new WebSocketException("Exception while closing client", e);
        }
    }

    public Future<String> registerExpectationCallback(ExpectationCallback<T> expectationCallback, EventLoopGroup eventLoopGroup, InetSocketAddress serverAddress, String contextPath, boolean isSecure) {
        if (this.expectationCallback == null) {
            this.expectationCallback = expectationCallback;
            return this.register(eventLoopGroup, serverAddress, contextPath, isSecure);
        }
        throw new IllegalArgumentException("It is not possible to set response callback once a forward callback has been set");
    }
}

