/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.integration.proxy;

import com.google.common.base.Charsets;
import java.io.OutputStream;
import java.net.Socket;
import javax.net.ssl.HostnameVerifier;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.StringStartsWith;
import org.junit.Assert;
import org.junit.Test;
import org.mockserver.client.proxy.ProxyClient;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpStatusCode;
import org.mockserver.socket.SSLFactory;
import org.mockserver.streams.IOStreamUtils;
import org.mockserver.verify.VerificationTimes;

public abstract class AbstractClientProxyIntegrationTest {
    protected static String servletContext = "";

    protected HttpClient createHttpClient() throws Exception {
        return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)new SSLConnectionSocketFactory(SSLFactory.getInstance().sslContext(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE)).setRoutePlanner((HttpRoutePlanner)new DefaultProxyRoutePlanner(new HttpHost(System.getProperty("http.proxyHost", "localhost"), Integer.parseInt(System.getProperty("http.proxyPort", String.valueOf(this.getProxyPort())))))).build();
    }

    public abstract int getProxyPort();

    public abstract ProxyClient getProxyClient();

    public abstract int getServerPort();

    protected String calculatePath(String path) {
        return ("/" + servletContext + "/" + path).replaceAll("//", "/");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldForwardRequestsUsingSocketDirectly() throws Exception {
        Socket socket = null;
        try {
            socket = new Socket("localhost", this.getProxyPort());
            OutputStream output = socket.getOutputStream();
            output.write(("GET " + this.calculatePath("test_headers_only") + " HTTP/1.1\r\n" + "Host: localhost:" + this.getServerPort() + "\r\n" + "x-test: test_headers_only\r\n" + "Connection: keep-alive\r\n" + "\r\n").getBytes(Charsets.UTF_8));
            output.flush();
            org.mockserver.test.Assert.assertContains(IOStreamUtils.readInputStreamToString((Socket)socket), "x-test: test_headers_only");
            this.getProxyClient().verify(HttpRequest.request().withMethod("GET").withPath("/test_headers_only"), VerificationTimes.exactly((int)1));
            output.write(("GET " + this.calculatePath("test_headers_and_body") + " HTTP/1.1\r\n" + "Host: localhost:" + this.getServerPort() + "\r\n" + "Content-Length: " + "an_example_body".getBytes(Charsets.UTF_8).length + "\r\n" + "x-test: test_headers_and_body\r\n" + "\r\n" + "an_example_body").getBytes(Charsets.UTF_8));
            output.flush();
            String response = IOStreamUtils.readInputStreamToString((Socket)socket);
            org.mockserver.test.Assert.assertContains(response, "x-test: test_headers_and_body");
            org.mockserver.test.Assert.assertContains(response, "an_example_body");
            this.getProxyClient().verify(HttpRequest.request().withMethod("GET").withPath("/test_headers_and_body").withBody("an_example_body"), VerificationTimes.exactly((int)1));
        }
        finally {
            if (socket != null) {
                socket.close();
            }
        }
    }

    @Test
    public void shouldForwardRequestsUsingHttpClient() throws Exception {
        HttpClient httpClient = this.createHttpClient();
        HttpPost request = new HttpPost(new URIBuilder().setScheme("http").setHost("localhost").setPort(this.getServerPort()).setPath(this.calculatePath("test_headers_and_body")).build());
        request.setEntity((HttpEntity)new StringEntity("an_example_body"));
        HttpResponse response = httpClient.execute((HttpUriRequest)request);
        Assert.assertEquals((long)HttpStatusCode.OK_200.code(), (long)response.getStatusLine().getStatusCode());
        Assert.assertEquals((Object)"an_example_body", (Object)new String(EntityUtils.toByteArray((HttpEntity)response.getEntity()), Charsets.UTF_8));
        this.getProxyClient().verify(HttpRequest.request().withMethod("POST").withPath("/test_headers_and_body").withBody("an_example_body"), VerificationTimes.exactly((int)1));
    }

    @Test
    public void shouldForwardRequestsWithComplexCookies() throws Exception {
        HttpClient httpClient = this.createHttpClient();
        BasicHeader setCookieOneHeader = new BasicHeader("Set-Cookie", "personalization_59996b985e24ce008d3df3bd07e27c1b=\"\"; Expires=Thu, 01-Jan-1970 00:00:10 GMT; Path=/");
        BasicHeader setCookieTwoHeader = new BasicHeader("Set-Cookie", "anonymous_59996b985e24ce008d3df3bd07e27c1b=acgzEaAKOVR=mAY9yJhP7IrC9Am; Version=1; Comment=\"Anonymous cookie for site\"; Max-Age=15552000; Expires=Sat, 19-Mar-2016 18:43:26 GMT; Path=/");
        BasicHeader cookieOneHeader = new BasicHeader("Cookie", "personalization_59996b985e24ce008d3df3bd07e27c1b=\"\"");
        BasicHeader cookieTwoHeader = new BasicHeader("Cookie", "anonymous_59996b985e24ce008d3df3bd07e27c1b=\"acgzEaAKOVR=mAY9yJhP7IrC9Am\"");
        HttpPost request = new HttpPost(new URIBuilder().setScheme("http").setHost("localhost").setPort(this.getServerPort()).setPath(this.calculatePath("test_headers_and_body")).build());
        request.addHeader((Header)setCookieOneHeader);
        request.addHeader((Header)setCookieTwoHeader);
        request.addHeader((Header)cookieOneHeader);
        request.addHeader((Header)cookieTwoHeader);
        request.setEntity((HttpEntity)new StringEntity("an_example_body"));
        HttpResponse response = httpClient.execute((HttpUriRequest)request);
        Assert.assertEquals((long)HttpStatusCode.OK_200.code(), (long)response.getStatusLine().getStatusCode());
        Assert.assertThat((Object)response.getHeaders("Set-Cookie").length, (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)response.getHeaders("Set-Cookie")[0].getValue(), (Matcher)Matchers.is((Object)setCookieOneHeader.getValue()));
        Assert.assertThat((Object)response.getHeaders("Set-Cookie")[1].getValue(), (Matcher)Matchers.is((Object)setCookieTwoHeader.getValue()));
        Assert.assertEquals((Object)"an_example_body", (Object)new String(EntityUtils.toByteArray((HttpEntity)response.getEntity()), Charsets.UTF_8));
        this.getProxyClient().verify(HttpRequest.request().withMethod("POST").withPath("/test_headers_and_body").withHeader(setCookieOneHeader.getName(), new String[]{setCookieOneHeader.getValue()}).withHeader(setCookieTwoHeader.getName(), new String[]{setCookieTwoHeader.getValue()}).withCookie("personalization_59996b985e24ce008d3df3bd07e27c1b", "").withCookie("anonymous_59996b985e24ce008d3df3bd07e27c1b", "acgzEaAKOVR=mAY9yJhP7IrC9Am").withBody("an_example_body"), VerificationTimes.exactly((int)1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldForwardRequestsToUnknownPath() throws Exception {
        Socket socket = null;
        try {
            socket = new Socket("localhost", this.getProxyPort());
            OutputStream output = socket.getOutputStream();
            output.write(("GET " + this.calculatePath("not_found") + " HTTP/1.1\r\n" + "Host: localhost:" + this.getServerPort() + "\r\n" + "Connection: close\r\n" + "\r\n").getBytes(Charsets.UTF_8));
            output.flush();
            org.mockserver.test.Assert.assertContains(IOStreamUtils.readInputStreamToString((Socket)socket), "HTTP/1.1 404 Not Found");
            this.getProxyClient().verify(HttpRequest.request().withMethod("GET").withPath("/not_found"), VerificationTimes.exactly((int)1));
        }
        finally {
            if (socket != null) {
                socket.close();
            }
        }
    }

    @Test
    public void shouldVerifyRequests() throws Exception {
        HttpClient httpClient = this.createHttpClient();
        httpClient.execute((HttpUriRequest)new HttpGet(new URIBuilder().setScheme("http").setHost("localhost").setPort(this.getServerPort()).setPath(this.calculatePath("test_headers_and_body")).build()));
        httpClient.execute((HttpUriRequest)new HttpGet(new URIBuilder().setScheme("http").setHost("localhost").setPort(this.getServerPort()).setPath(this.calculatePath("test_headers_only")).build()));
        this.getProxyClient().verify(new HttpRequest[]{HttpRequest.request().withMethod("GET").withPath("/test_headers_and_body")});
        this.getProxyClient().verify(HttpRequest.request().withMethod("GET").withPath("/test_headers_and_body"), VerificationTimes.exactly((int)1));
        this.getProxyClient().verify(HttpRequest.request().withPath("/test_headers_.*"), VerificationTimes.atLeast((int)1));
        this.getProxyClient().verify(HttpRequest.request().withPath("/test_headers_.*"), VerificationTimes.exactly((int)2));
        this.getProxyClient().verify(HttpRequest.request().withPath("/other_path"), VerificationTimes.exactly((int)0));
    }

    @Test
    public void shouldVerifyZeroRequests() throws Exception {
        HttpClient httpClient = this.createHttpClient();
        httpClient.execute((HttpUriRequest)new HttpGet(new URIBuilder().setScheme("http").setHost("localhost").setPort(this.getServerPort()).setPath(this.calculatePath("test_headers_and_body")).build()));
        try {
            this.getProxyClient().verify(HttpRequest.request().withPath("/test_headers_and_body"), VerificationTimes.exactly((int)0));
            Assert.fail();
        }
        catch (AssertionError ae) {
            Assert.assertThat((Object)((Throwable)((Object)ae)).getMessage(), (Matcher)StringStartsWith.startsWith((String)("Request not found exactly 0 times, expected:<{" + System.getProperty("line.separator") + "  \"path\" : \"" + "/test_headers_and_body" + "\"" + System.getProperty("line.separator") + "}> but was:<{" + System.getProperty("line.separator") + "  \"method\" : \"GET\"," + System.getProperty("line.separator") + "  \"path\" : \"" + "/test_headers_and_body" + "\"," + System.getProperty("line.separator"))));
        }
    }

    @Test
    public void shouldVerifyNoRequestsExactly() throws Exception {
        HttpClient httpClient = this.createHttpClient();
        httpClient.execute((HttpUriRequest)new HttpGet(new URIBuilder().setScheme("http").setHost("localhost").setPort(this.getServerPort()).setPath(this.calculatePath("test_headers_and_body")).build()));
        try {
            this.getProxyClient().verify(HttpRequest.request().withPath("/other_path"), VerificationTimes.exactly((int)1));
            Assert.fail();
        }
        catch (AssertionError ae) {
            Assert.assertThat((Object)((Throwable)((Object)ae)).getMessage(), (Matcher)StringStartsWith.startsWith((String)("Request not found exactly once, expected:<{" + System.getProperty("line.separator") + "  \"path\" : \"" + "/other_path" + "\"" + System.getProperty("line.separator") + "}> but was:<{" + System.getProperty("line.separator") + "  \"method\" : \"GET\"," + System.getProperty("line.separator") + "  \"path\" : \"" + "/test_headers_and_body" + "\"," + System.getProperty("line.separator"))));
        }
    }

    @Test
    public void shouldVerifyNoRequestsTimesNotSpecified() throws Exception {
        HttpClient httpClient = this.createHttpClient();
        httpClient.execute((HttpUriRequest)new HttpGet(new URIBuilder().setScheme("http").setHost("localhost").setPort(this.getServerPort()).setPath(this.calculatePath("test_headers_and_body")).build()));
        try {
            this.getProxyClient().verify(new HttpRequest[]{HttpRequest.request().withPath("/other_path")});
            Assert.fail();
        }
        catch (AssertionError ae) {
            Assert.assertThat((Object)((Throwable)((Object)ae)).getMessage(), (Matcher)StringStartsWith.startsWith((String)("Request sequence not found, expected:<[ {" + System.getProperty("line.separator") + "  \"path\" : \"" + "/other_path" + "\"" + System.getProperty("line.separator") + "} ]> but was:<[ {" + System.getProperty("line.separator") + "  \"method\" : \"GET\"," + System.getProperty("line.separator") + "  \"path\" : \"" + "/test_headers_and_body" + "\"," + System.getProperty("line.separator"))));
        }
    }

    @Test
    public void shouldVerifyNotEnoughRequests() throws Exception {
        HttpClient httpClient = this.createHttpClient();
        httpClient.execute((HttpUriRequest)new HttpGet(new URIBuilder().setScheme("http").setHost("localhost").setPort(this.getServerPort()).setPath(this.calculatePath("test_headers_and_body")).build()));
        httpClient.execute((HttpUriRequest)new HttpGet(new URIBuilder().setScheme("http").setHost("localhost").setPort(this.getServerPort()).setPath(this.calculatePath("test_headers_and_body")).build()));
        try {
            this.getProxyClient().verify(HttpRequest.request().withPath("/test_headers_and_body"), VerificationTimes.atLeast((int)3));
            Assert.fail();
        }
        catch (AssertionError ae) {
            Assert.assertThat((Object)((Throwable)((Object)ae)).getMessage(), (Matcher)StringStartsWith.startsWith((String)("Request not found at least 3 times, expected:<{" + System.getProperty("line.separator") + "  \"path\" : \"" + "/test_headers_and_body" + "\"" + System.getProperty("line.separator") + "}> but was:<[ {" + System.getProperty("line.separator") + "  \"method\" : \"GET\"," + System.getProperty("line.separator") + "  \"path\" : \"" + "/test_headers_and_body" + "\"," + System.getProperty("line.separator"))));
        }
    }

    @Test
    public void shouldClearRequests() throws Exception {
        HttpClient httpClient = this.createHttpClient();
        httpClient.execute((HttpUriRequest)new HttpGet(new URIBuilder().setScheme("http").setHost("localhost").setPort(this.getServerPort()).setPath(this.calculatePath("test_headers_and_body")).build()));
        httpClient.execute((HttpUriRequest)new HttpGet(new URIBuilder().setScheme("http").setHost("localhost").setPort(this.getServerPort()).setPath(this.calculatePath("test_headers_only")).build()));
        this.getProxyClient().clear(HttpRequest.request().withMethod("GET").withPath("/test_headers_and_body"));
        this.getProxyClient().verify(HttpRequest.request().withMethod("GET").withPath("/test_headers_and_body"), VerificationTimes.exactly((int)0));
        this.getProxyClient().verify(HttpRequest.request().withPath("/test_headers_.*"), VerificationTimes.exactly((int)1));
    }

    @Test
    public void shouldResetRequests() throws Exception {
        HttpClient httpClient = this.createHttpClient();
        httpClient.execute((HttpUriRequest)new HttpGet(new URIBuilder().setScheme("http").setHost("localhost").setPort(this.getServerPort()).setPath(this.calculatePath("test_headers_and_body")).build()));
        httpClient.execute((HttpUriRequest)new HttpGet(new URIBuilder().setScheme("http").setHost("localhost").setPort(this.getServerPort()).setPath(this.calculatePath("test_headers_only")).build()));
        this.getProxyClient().reset();
        this.getProxyClient().verify(HttpRequest.request().withMethod("GET").withPath("/test_headers_and_body"), VerificationTimes.exactly((int)0));
        this.getProxyClient().verify(HttpRequest.request().withPath("/test_headers_.*"), VerificationTimes.atLeast((int)0));
        this.getProxyClient().verify(HttpRequest.request().withPath("/test_headers_.*"), VerificationTimes.exactly((int)0));
    }
}

