/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.integration.proxy;

import com.google.common.base.Charsets;
import java.io.OutputStream;
import java.net.Socket;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocket;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.util.EntityUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mockserver.client.proxy.ProxyClient;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpStatusCode;
import org.mockserver.socket.SSLFactory;
import org.mockserver.streams.IOStreamUtils;
import org.mockserver.verify.VerificationTimes;

public abstract class AbstractClientSecureProxyIntegrationTest {
    public abstract int getProxyPort();

    public abstract int getServerSecurePort();

    public abstract ProxyClient getProxyClient();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldConnectToSecurePort() throws Exception {
        Socket socket = null;
        try {
            socket = new Socket("localhost", this.getProxyPort());
            OutputStream output = socket.getOutputStream();
            output.write(("CONNECT localhost:443 HTTP/1.1\r\nHost: localhost:" + this.getServerSecurePort() + "\r\n" + "\r\n").getBytes(Charsets.UTF_8));
            output.flush();
            org.mockserver.test.Assert.assertContains(IOStreamUtils.readInputStreamToString((Socket)socket), "HTTP/1.1 200 OK");
        }
        finally {
            if (socket != null) {
                socket.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldForwardRequestsToSecurePortUsingSocketDirectly() throws Exception {
        Socket socket = null;
        try {
            socket = new Socket("localhost", this.getProxyPort());
            OutputStream output = socket.getOutputStream();
            output.write(("CONNECT localhost:443 HTTP/1.1\r\nHost: localhost:" + this.getServerSecurePort() + "\r\n" + "\r\n").getBytes(Charsets.UTF_8));
            output.flush();
            org.mockserver.test.Assert.assertContains(IOStreamUtils.readInputStreamToString((Socket)socket), "HTTP/1.1 200 OK");
            SSLSocket sslSocket = null;
            try {
                sslSocket = SSLFactory.getInstance().wrapSocket(socket);
                output = sslSocket.getOutputStream();
                output.write(("GET /test_headers_only HTTP/1.1\r\nHost: localhost:" + this.getServerSecurePort() + "\r\n" + "X-Test: test_headers_only\r\n" + "Connection: keep-alive\r\n" + "\r\n").getBytes(Charsets.UTF_8));
                output.flush();
                org.mockserver.test.Assert.assertContains(IOStreamUtils.readInputStreamToString((Socket)sslSocket), "X-Test: test_headers_only");
                output.write(("GET /test_headers_and_body HTTP/1.1\r\nHost: localhost:" + this.getServerSecurePort() + "\r\n" + "Content-Length: " + "an_example_body".getBytes(Charsets.UTF_8).length + "\r\n" + "X-Test: test_headers_and_body\r\n" + "\r\n" + "an_example_body").getBytes(Charsets.UTF_8));
                output.flush();
                String response = IOStreamUtils.readInputStreamToString((Socket)sslSocket);
                org.mockserver.test.Assert.assertContains(response, "X-Test: test_headers_and_body");
                org.mockserver.test.Assert.assertContains(response, "an_example_body");
                this.getProxyClient().verify(HttpRequest.request().withMethod("GET").withPath("/test_headers_and_body").withBody("an_example_body"), VerificationTimes.exactly((int)1));
            }
            finally {
                if (sslSocket != null) {
                    sslSocket.close();
                }
            }
        }
        finally {
            if (socket != null) {
                socket.close();
            }
        }
    }

    @Test
    public void shouldForwardRequestsToSecurePortUsingHttpClientViaHTTP_CONNECT() throws Exception {
        CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)new SSLConnectionSocketFactory(SSLFactory.getInstance().sslContext(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE)).setRoutePlanner((HttpRoutePlanner)new DefaultProxyRoutePlanner(new HttpHost(System.getProperty("http.proxyHost"), Integer.parseInt(System.getProperty("http.proxyPort"))))).build();
        HttpPost request = new HttpPost(new URIBuilder().setScheme("https").setHost("localhost").setPort(this.getServerSecurePort()).setPath("/test_headers_and_body").build());
        request.setEntity((HttpEntity)new StringEntity("an_example_body"));
        HttpResponse response = httpClient.execute((HttpUriRequest)request);
        Assert.assertEquals((long)HttpStatusCode.OK_200.code(), (long)response.getStatusLine().getStatusCode());
        Assert.assertEquals((Object)"an_example_body", (Object)new String(EntityUtils.toByteArray((HttpEntity)response.getEntity()), Charsets.UTF_8));
        this.getProxyClient().verify(HttpRequest.request().withPath("/test_headers_and_body").withBody("an_example_body"), VerificationTimes.exactly((int)1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldForwardRequestsToSecurePortAndUnknownPath() throws Exception {
        Socket socket = null;
        try {
            socket = new Socket("localhost", this.getProxyPort());
            OutputStream output = socket.getOutputStream();
            output.write(("CONNECT localhost:443 HTTP/1.1\r\nHost: localhost:" + this.getServerSecurePort() + "\r\n" + "\r\n").getBytes(Charsets.UTF_8));
            output.flush();
            org.mockserver.test.Assert.assertContains(IOStreamUtils.readInputStreamToString((Socket)socket), "HTTP/1.1 200 OK");
            SSLSocket sslSocket = null;
            try {
                sslSocket = SSLFactory.getInstance().wrapSocket(socket);
                output = sslSocket.getOutputStream();
                output.write(("GET /not_found HTTP/1.1\r\nHost: localhost:" + this.getServerSecurePort() + "\r\n" + "\r\n").getBytes(Charsets.UTF_8));
                output.flush();
                org.mockserver.test.Assert.assertContains(IOStreamUtils.readInputStreamToString((Socket)sslSocket), "HTTP/1.1 404 Not Found");
                this.getProxyClient().verify(HttpRequest.request().withMethod("GET").withPath("/not_found"), VerificationTimes.exactly((int)1));
            }
            finally {
                if (sslSocket != null) {
                    sslSocket.close();
                }
            }
        }
        finally {
            if (socket != null) {
                socket.close();
            }
        }
    }
}

