/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.maven;

import com.google.common.annotations.VisibleForTesting;
import org.mockserver.client.proxy.ProxyClient;
import org.mockserver.client.server.MockServerClient;
import org.mockserver.initialize.ExpectationInitializer;
import org.mockserver.mockserver.MockServer;
import org.mockserver.mockserver.MockServerBuilder;
import org.mockserver.model.EqualsHashCodeToString;
import org.mockserver.proxy.http.HttpProxy;
import org.mockserver.proxy.http.HttpProxyBuilder;

public class InstanceHolder
extends EqualsHashCodeToString {
    @VisibleForTesting
    static HttpProxyBuilder proxyBuilder = new HttpProxyBuilder();
    @VisibleForTesting
    static MockServerBuilder mockServerBuilder = new MockServerBuilder();
    private HttpProxy proxy;
    private MockServer mockServer;

    public static void runInitializationClass(int mockServerPort, ExpectationInitializer expectationInitializer) {
        if (mockServerPort != -1 && expectationInitializer != null) {
            expectationInitializer.initializeExpectations(new MockServerClient("127.0.0.1", mockServerPort));
        }
    }

    public void start(int mockServerPort, int mockServerSecurePort, int proxyPort, int proxySecurePort, ExpectationInitializer expectationInitializer) {
        if (this.mockServer == null || !this.mockServer.isRunning()) {
            if (mockServerPort != -1 || mockServerSecurePort != -1) {
                this.mockServer = mockServerBuilder.withHTTPPort(Integer.valueOf(mockServerPort)).withHTTPSPort(Integer.valueOf(mockServerSecurePort)).build();
            }
        } else {
            throw new IllegalStateException("MockServer is already running!");
        }
        InstanceHolder.runInitializationClass(mockServerPort, expectationInitializer);
        if (this.proxy == null || !this.proxy.isRunning()) {
            if (proxyPort != -1 || proxySecurePort != -1) {
                this.proxy = proxyBuilder.withHTTPPort(Integer.valueOf(proxyPort)).withHTTPSPort(Integer.valueOf(proxySecurePort)).build();
            }
        } else {
            throw new IllegalStateException("Proxy is already running!");
        }
    }

    public void stop(int mockServerPort, int proxyPort) {
        if (mockServerPort != -1) {
            this.newMockServerClient(mockServerPort).stop();
        }
        if (proxyPort != -1) {
            this.newProxyClient(proxyPort).stop();
        }
    }

    @VisibleForTesting
    ProxyClient newProxyClient(int proxyStopPort) {
        return new ProxyClient("127.0.0.1", proxyStopPort);
    }

    @VisibleForTesting
    MockServerClient newMockServerClient(int mockServerPort) {
        return new MockServerClient("127.0.0.1", mockServerPort);
    }

    public void stop() {
        if (this.mockServer != null && this.mockServer.isRunning()) {
            this.mockServer.stop();
        }
        if (this.proxy != null && this.proxy.isRunning()) {
            this.proxy.stop();
        }
    }
}

