/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mockserver;

import com.google.common.annotations.VisibleForTesting;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpMessage;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.CharsetUtil;
import org.mockserver.client.serialization.ExpectationSerializer;
import org.mockserver.client.serialization.HttpRequestSerializer;
import org.mockserver.mappers.MockServerToNettyResponseMapper;
import org.mockserver.mappers.NettyToMockServerRequestMapper;
import org.mockserver.mock.Expectation;
import org.mockserver.mock.MockServerMatcher;
import org.mockserver.mock.action.HttpCallbackActionHandler;
import org.mockserver.mock.action.HttpForwardActionHandler;
import org.mockserver.mock.action.HttpResponseActionHandler;
import org.mockserver.mockserver.MockServer;
import org.mockserver.model.Action;
import org.mockserver.model.HttpCallback;
import org.mockserver.model.HttpForward;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.NettyHttpRequest;
import org.mockserver.proxy.filters.Filters;
import org.mockserver.proxy.filters.HopByHopHeaderFilter;
import org.mockserver.proxy.filters.LogFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class MockServerHandler
extends SimpleChannelInboundHandler<Object> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final MockServer server;
    private final LogFilter logFilter;
    private final MockServerMatcher mockServerMatcher;
    private final boolean secure;
    private HttpForwardActionHandler httpForwardActionHandler;
    private HttpCallbackActionHandler httpCallbackActionHandler;
    private HttpResponseActionHandler httpResponseActionHandler;
    private NettyToMockServerRequestMapper nettyToMockServerRequestMapper = new NettyToMockServerRequestMapper();
    private MockServerToNettyResponseMapper mockServerToNettyResponseMapper = new MockServerToNettyResponseMapper();
    private ExpectationSerializer expectationSerializer = new ExpectationSerializer();
    private HttpRequestSerializer httpRequestSerializer = new HttpRequestSerializer();

    public MockServerHandler(MockServerMatcher mockServerMatcher, LogFilter logFilter, MockServer server, boolean secure) {
        this.mockServerMatcher = mockServerMatcher;
        this.logFilter = logFilter;
        this.server = server;
        this.secure = secure;
        Filters filters = new Filters();
        filters.withFilter(new org.mockserver.model.HttpRequest(), new HopByHopHeaderFilter());
        filters.withFilter(new org.mockserver.model.HttpRequest(), logFilter);
        this.httpResponseActionHandler = new HttpResponseActionHandler(filters);
        this.httpCallbackActionHandler = new HttpCallbackActionHandler(filters);
        this.httpForwardActionHandler = new HttpForwardActionHandler(filters);
    }

    public boolean isSecure() {
        return this.secure;
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof FullHttpMessage && ((HttpObject)msg).getDecoderResult().isSuccess()) {
            LastHttpContent trailer;
            HttpRequest request = (HttpRequest)msg;
            NettyHttpRequest mockServerHttpRequest = new NettyHttpRequest(request.getProtocolVersion(), request.getMethod(), request.getUri(), this.secure);
            mockServerHttpRequest.headers().add(request.headers());
            ByteBuf content = ((HttpContent)msg).content();
            if (content.isReadable()) {
                mockServerHttpRequest.content(content);
            }
            if (!(trailer = (LastHttpContent)msg).trailingHeaders().isEmpty()) {
                mockServerHttpRequest.headers().entries().addAll(trailer.trailingHeaders().entries());
            }
            if (mockServerHttpRequest.matches(HttpMethod.PUT, "/stop")) {
                this.writeResponse(ctx, new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.ACCEPTED), HttpHeaders.isKeepAlive(request), HttpHeaders.is100ContinueExpected(request));
                ctx.close();
                this.server.stop();
            } else {
                this.writeResponse(ctx, this.mockResponse(mockServerHttpRequest), HttpHeaders.isKeepAlive(request), HttpHeaders.is100ContinueExpected(request));
            }
        } else {
            ctx.write(new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_REQUEST));
        }
    }

    private void writeResponse(ChannelHandlerContext ctx, FullHttpResponse response, boolean isKeepAlive, boolean is100ContinueExpected) {
        response.headers().set("Content-Length", (Object)response.content().readableBytes());
        if (isKeepAlive) {
            response.headers().set("Connection", (Object)"keep-alive");
        } else {
            response.headers().set("Connection", (Object)"close");
        }
        if (is100ContinueExpected) {
            ctx.write(new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE));
        }
        ctx.write(response);
        ctx.flush();
    }

    @VisibleForTesting
    FullHttpResponse mockResponse(NettyHttpRequest nettyHttpRequest) {
        try {
            String content;
            String string = content = nettyHttpRequest.content() != null ? nettyHttpRequest.content().toString(CharsetUtil.UTF_8) : "";
            if (nettyHttpRequest.matches(HttpMethod.PUT, "/dumpToLog")) {
                this.mockServerMatcher.dumpToLog(this.httpRequestSerializer.deserialize(content));
                return new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.ACCEPTED);
            }
            if (nettyHttpRequest.matches(HttpMethod.PUT, "/reset")) {
                this.logFilter.reset();
                this.mockServerMatcher.reset();
                return new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.ACCEPTED);
            }
            if (nettyHttpRequest.matches(HttpMethod.PUT, "/clear")) {
                org.mockserver.model.HttpRequest httpRequest = this.httpRequestSerializer.deserialize(content);
                this.logFilter.clear(httpRequest);
                this.mockServerMatcher.clear(httpRequest);
                return new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.ACCEPTED);
            }
            if (nettyHttpRequest.matches(HttpMethod.PUT, "/expectation")) {
                Expectation expectation = this.expectationSerializer.deserialize(content);
                this.mockServerMatcher.when(expectation.getHttpRequest(), expectation.getTimes()).thenRespond(expectation.getHttpResponse(false)).thenForward(expectation.getHttpForward()).thenCallback(expectation.getHttpCallback());
                return new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CREATED);
            }
            if (nettyHttpRequest.matches(HttpMethod.PUT, "/retrieve")) {
                Expectation[] expectations = this.logFilter.retrieve(this.httpRequestSerializer.deserialize(content));
                return new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.copiedBuffer(this.expectationSerializer.serialize(expectations).getBytes()));
            }
            org.mockserver.model.HttpRequest httpRequest = this.nettyToMockServerRequestMapper.mapNettyRequestToMockServerRequest(nettyHttpRequest);
            Action action = this.mockServerMatcher.handle(httpRequest);
            if (action != null) {
                switch (action.getType()) {
                    case FORWARD: {
                        return this.mapResponse(this.httpForwardActionHandler.handle((HttpForward)action, httpRequest));
                    }
                    case CALLBACK: {
                        return this.mapResponse(this.httpCallbackActionHandler.handle((HttpCallback)action, httpRequest));
                    }
                    case RESPONSE: {
                        return this.mapResponse(this.httpResponseActionHandler.handle((HttpResponse)action, httpRequest));
                    }
                }
                return new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_FOUND);
            }
            return new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_FOUND);
        }
        catch (Exception e) {
            this.logger.error("Exception processing " + nettyHttpRequest, e);
            return new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_REQUEST);
        }
    }

    private FullHttpResponse mapResponse(HttpResponse httpResponse) {
        if (httpResponse != null) {
            return this.mockServerToNettyResponseMapper.mapMockServerResponseToNettyResponse(httpResponse);
        }
        return new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (!cause.getMessage().contains("Connection reset by peer")) {
            this.logger.warn("Exception caught by MockServer handler closing pipeline", cause);
        }
        ctx.close();
    }
}

