/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.model;

import java.util.concurrent.TimeUnit;
import org.mockserver.model.EqualsHashCodeToString;

public class Delay
extends EqualsHashCodeToString {
    private final TimeUnit timeUnit;
    private final long value;

    public Delay(TimeUnit timeUnit, long value) {
        this.timeUnit = timeUnit;
        this.value = value;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public long getValue() {
        return this.value;
    }

    public void applyDelay() {
        if (this.timeUnit != null) {
            try {
                this.timeUnit.sleep(this.value);
            }
            catch (InterruptedException ie) {
                this.logger.error("InterruptedException while apply delay to response", ie);
                throw new RuntimeException("InterruptedException while apply delay to response", ie);
            }
        }
    }
}

