/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.mockserver.client.serialization.ObjectMapperFactory;
import org.mockserver.model.BinaryBody;
import org.mockserver.model.Body;
import org.mockserver.model.Cookie;
import org.mockserver.model.EqualsHashCodeToString;
import org.mockserver.model.Header;
import org.mockserver.model.Parameter;
import org.mockserver.model.StringBody;

public class HttpRequest
extends EqualsHashCodeToString {
    private String method = "";
    private String url = "";
    private String path = "";
    private Map<String, Parameter> queryStringParameters = new LinkedHashMap<String, Parameter>();
    private Body body = null;
    private byte[] rawBodyBytes = null;
    private Map<String, Header> headers = new LinkedHashMap<String, Header>();
    private Map<String, Cookie> cookies = new LinkedHashMap<String, Cookie>();

    public static HttpRequest request() {
        return new HttpRequest();
    }

    public HttpRequest withMethod(String method) {
        this.method = method;
        return this;
    }

    public String getMethod() {
        return this.method;
    }

    public String getURL() {
        return this.url;
    }

    public HttpRequest withURL(String url) {
        this.url = url;
        return this;
    }

    public String getPath() {
        return this.path;
    }

    public HttpRequest withPath(String path) {
        this.path = path;
        return this;
    }

    public HttpRequest withQueryStringParameters(List<Parameter> parameters) {
        this.queryStringParameters.clear();
        for (Parameter parameter : parameters) {
            this.withQueryStringParameter(parameter);
        }
        return this;
    }

    public HttpRequest withQueryStringParameters(Parameter ... parameters) {
        return this.withQueryStringParameters(Arrays.asList(parameters));
    }

    public HttpRequest withQueryStringParameters(Map<String, List<String>> parameters) {
        this.queryStringParameters.clear();
        for (String name : parameters.keySet()) {
            for (String value : parameters.get(name)) {
                this.withQueryStringParameter(new Parameter(name, value));
            }
        }
        return this;
    }

    public HttpRequest withQueryStringParameter(Parameter parameter) {
        if (this.queryStringParameters.containsKey(parameter.getName())) {
            this.queryStringParameters.get(parameter.getName()).addValues(parameter.getValues());
        } else {
            this.queryStringParameters.put(parameter.getName(), parameter);
        }
        return this;
    }

    public List<Parameter> getQueryStringParameters() {
        return new ArrayList<Parameter>(this.queryStringParameters.values());
    }

    public Body getBody() {
        return this.body;
    }

    public byte[] getRawBodyBytes() {
        return this.rawBodyBytes;
    }

    public void setRawBodyBytes(byte[] bodyBytes) {
        this.rawBodyBytes = bodyBytes;
    }

    public HttpRequest withBody(String body) {
        this.body = new StringBody(body, Body.Type.STRING);
        return this;
    }

    public HttpRequest withBody(Body body) {
        if (body instanceof BinaryBody) {
            this.setRawBodyBytes(((BinaryBody)body).getValue());
        }
        this.body = body;
        return this;
    }

    public HttpRequest withHeaders(List<Header> headers) {
        this.headers.clear();
        for (Header header : headers) {
            this.withHeader(header);
        }
        return this;
    }

    public HttpRequest withHeaders(Header ... headers) {
        this.withHeaders(Arrays.asList(headers));
        return this;
    }

    public HttpRequest withHeader(Header header) {
        if (this.headers.containsKey(header.getName())) {
            this.headers.get(header.getName()).addValues(header.getValues());
        } else {
            this.headers.put(header.getName(), header);
        }
        return this;
    }

    public HttpRequest replaceHeader(Header header) {
        for (String key : new HashSet<String>(this.headers.keySet())) {
            if (!header.getName().equalsIgnoreCase(key)) continue;
            this.headers.remove(key);
        }
        this.headers.put(header.getName(), header);
        return this;
    }

    public List<Header> getHeaders() {
        return new ArrayList<Header>(this.headers.values());
    }

    public boolean containsHeader(String name) {
        return this.headers.containsKey(name);
    }

    public HttpRequest withCookies(List<Cookie> cookies) {
        this.cookies.clear();
        for (Cookie cookie : cookies) {
            this.withCookie(cookie);
        }
        return this;
    }

    public HttpRequest withCookies(Cookie ... cookies) {
        this.withCookies(Arrays.asList(cookies));
        return this;
    }

    public HttpRequest withCookie(Cookie cookie) {
        if (this.cookies.containsKey(cookie.getName())) {
            this.cookies.get(cookie.getName()).addValues(cookie.getValues());
        } else {
            this.cookies.put(cookie.getName(), cookie);
        }
        return this;
    }

    public List<Cookie> getCookies() {
        return new ArrayList<Cookie>(this.cookies.values());
    }

    @JsonIgnore
    public int getPort() {
        if (this.url != null) {
            URL url = null;
            try {
                url = new URL(this.url);
            }
            catch (MalformedURLException murle) {
                this.logger.debug("MalformedURLException parsing uri [" + this.url + "]", murle);
            }
            if (url != null && url.getPort() != -1) {
                return url.getPort();
            }
            if (this.url.startsWith("https")) {
                return 443;
            }
            return 80;
        }
        return 80;
    }

    @Override
    public String toString() {
        try {
            return ObjectMapperFactory.createObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(this);
        }
        catch (Exception e) {
            return super.toString();
        }
    }
}

