/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.model;

import org.mockserver.model.Body;

public class StringBody
extends Body<String> {
    private final String value;

    public StringBody(String value) {
        super(Body.Type.STRING);
        this.value = value;
    }

    public StringBody(String value, Body.Type type) {
        super(type);
        this.value = value;
    }

    public static StringBody exact(String body) {
        return new StringBody(body, Body.Type.STRING);
    }

    public static StringBody regex(String body) {
        return new StringBody(body, Body.Type.REGEX);
    }

    public static StringBody xpath(String body) {
        return new StringBody(body, Body.Type.XPATH);
    }

    public static StringBody json(String body) {
        return new StringBody(body, Body.Type.JSON);
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public String toString() {
        return this.value;
    }
}

