/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.proxy.http.direct;

import com.google.common.base.Charsets;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.ssl.SslHandler;
import java.net.InetSocketAddress;
import javax.net.ssl.SSLEngine;
import org.mockserver.logging.LoggingHandler;
import org.mockserver.proxy.http.relay.BasicHttpDecoder;
import org.mockserver.proxy.http.relay.ProxyRelayHandler;
import org.mockserver.proxy.interceptor.Interceptor;
import org.mockserver.proxy.interceptor.ResponseInterceptor;
import org.mockserver.socket.SSLFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectProxyUpstreamHandler
extends ChannelDuplexHandler {
    private final Logger logger;
    private final InetSocketAddress remoteSocketAddress;
    private final boolean secure;
    private final int bufferedCapacity;
    private final Interceptor interceptor;
    private volatile Channel outboundChannel;
    private volatile ByteBuf channelBuffer;
    private volatile boolean bufferedMode;
    private volatile boolean flushedBuffer;
    private volatile Integer contentLength;
    private volatile int contentSoFar;
    private volatile boolean flushContent;

    public DirectProxyUpstreamHandler(InetSocketAddress remoteSocketAddress, boolean secure, int bufferedCapacity, Interceptor interceptor, String loggerName) {
        this.remoteSocketAddress = remoteSocketAddress;
        this.secure = secure;
        this.bufferedCapacity = bufferedCapacity;
        this.interceptor = interceptor;
        this.logger = LoggerFactory.getLogger(loggerName);
        this.bufferedMode = bufferedCapacity > 0;
        this.flushedBuffer = false;
        this.contentLength = null;
        this.contentSoFar = 0;
        this.flushContent = false;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.channelBuffer = Unpooled.directBuffer(this.bufferedCapacity);
        super.handlerAdded(ctx);
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        if (this.channelBuffer.refCnt() >= 1) {
            this.channelBuffer.release();
        }
        super.handlerRemoved(ctx);
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        final Channel inboundChannel = ctx.channel();
        Bootstrap bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group(inboundChannel.eventLoop())).channel(ctx.channel().getClass())).handler(new ChannelInitializer<SocketChannel>(){

            @Override
            public void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                if (DirectProxyUpstreamHandler.this.logger.isDebugEnabled()) {
                    pipeline.addLast("logger", (ChannelHandler)new LoggingHandler(DirectProxyUpstreamHandler.this.logger));
                }
                if (DirectProxyUpstreamHandler.this.secure) {
                    SSLEngine engine = SSLFactory.getInstance().sslContext().createSSLEngine();
                    engine.setUseClientMode(true);
                    pipeline.addLast("proxy -> server ssl", (ChannelHandler)new SslHandler(engine));
                }
                pipeline.addLast(new ProxyRelayHandler(inboundChannel, DirectProxyUpstreamHandler.this.bufferedCapacity, new ResponseInterceptor(), DirectProxyUpstreamHandler.this.logger));
            }
        })).option(ChannelOption.AUTO_READ, false);
        ChannelFuture channelFuture = bootstrap.connect(this.remoteSocketAddress);
        this.outboundChannel = channelFuture.channel();
        channelFuture.addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    DirectProxyUpstreamHandler.this.channelBuffer.clear();
                    DirectProxyUpstreamHandler.this.bufferedMode = DirectProxyUpstreamHandler.this.bufferedCapacity > 0;
                    DirectProxyUpstreamHandler.this.flushedBuffer = false;
                    inboundChannel.read();
                } else {
                    DirectProxyUpstreamHandler.this.logger.warn("Failed to connect to: " + DirectProxyUpstreamHandler.this.remoteSocketAddress, future.cause());
                    inboundChannel.close();
                }
            }
        });
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (this.outboundChannel.isActive()) {
            if (this.bufferedMode && this.channelBuffer.isReadable()) {
                this.flushedBuffer = true;
                this.logger.debug("CHANNEL INACTIVE: " + this.channelBuffer.toString(Charsets.UTF_8));
                this.outboundChannel.writeAndFlush(this.interceptor.intercept(ctx, this.channelBuffer, this.logger)).addListener(new ChannelFutureListener(){

                    @Override
                    public void operationComplete(ChannelFuture future) throws Exception {
                        if (future.isSuccess()) {
                            DirectProxyUpstreamHandler.this.channelBuffer.clear();
                            DirectProxyUpstreamHandler.this.outboundChannel.writeAndFlush(Unpooled.EMPTY_BUFFER).addListener(ChannelFutureListener.CLOSE);
                        } else {
                            DirectProxyUpstreamHandler.this.logger.warn("Failed to send flush channel buffer", future.cause());
                            future.channel().close();
                        }
                    }
                });
            } else {
                this.outboundChannel.writeAndFlush(Unpooled.EMPTY_BUFFER).addListener(ChannelFutureListener.CLOSE);
            }
        }
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        if (this.bufferedMode && this.outboundChannel.isActive() && this.channelBuffer.isReadable()) {
            this.flushedBuffer = true;
            this.logger.debug("CHANNEL READ COMPLETE: " + this.channelBuffer.toString(Charsets.UTF_8));
            this.outboundChannel.writeAndFlush(this.interceptor.intercept(ctx, this.channelBuffer, this.logger)).addListener(new ChannelFutureListener(){

                @Override
                public void operationComplete(ChannelFuture future) throws Exception {
                    if (future.isSuccess()) {
                        DirectProxyUpstreamHandler.this.channelBuffer.clear();
                    } else {
                        DirectProxyUpstreamHandler.this.logger.warn("Failed to write to: " + DirectProxyUpstreamHandler.this.remoteSocketAddress, future.cause());
                        future.channel().close();
                    }
                }
            });
        }
        super.channelReadComplete(ctx);
    }

    @Override
    public void channelRead(final ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof ByteBuf) {
            final ByteBuf chunk = (ByteBuf)msg;
            if (this.flushedBuffer) {
                this.bufferedMode = false;
            }
            if (this.bufferedMode) {
                this.flushContent = false;
                if (this.contentLength != null) {
                    this.contentSoFar += chunk.readableBytes();
                } else {
                    BasicHttpDecoder basicHttpDecoder = new BasicHttpDecoder(Unpooled.copiedBuffer(chunk));
                    this.contentLength = basicHttpDecoder.getContentLength();
                    this.contentSoFar = chunk.readableBytes() - basicHttpDecoder.getContentStart();
                }
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("CHUNK:                     ---\n-" + System.getProperty("line.separator") + Unpooled.copiedBuffer(chunk).toString(Charsets.UTF_8) + "\n-" + System.getProperty("line.separator"));
                    this.logger.trace("CONTENT-SO-FAR-PRE-CHUNK:  --- " + (this.contentSoFar - Unpooled.copiedBuffer(chunk).toString(Charsets.UTF_8).length()));
                    this.logger.trace("CHUNK-SIZE:                --- " + chunk.readableBytes());
                    this.logger.trace("CONTENT-SO-FAR-PRE-CHUNK:  --- " + this.contentSoFar);
                    if (this.contentLength != null) {
                        this.logger.trace("CONTENT-REMAINING:         --- " + (this.contentLength - this.contentSoFar));
                        this.logger.trace("CONTENT-LENGTH:            --- " + this.contentLength);
                    }
                }
                if (this.contentLength != null) {
                    this.logger.trace("Flushing buffer as all content received");
                    this.flushContent = this.contentSoFar >= this.contentLength || chunk.readableBytes() == 0;
                }
                try {
                    this.channelBuffer.writeBytes(chunk);
                    ctx.channel().read();
                }
                catch (IndexOutOfBoundsException iobe) {
                    this.logger.trace("Flushing buffer upstream and switching to chunked mode as downstream response too large");
                    this.bufferedMode = false;
                    if (this.outboundChannel.isActive() && this.channelBuffer.isReadable()) {
                        this.logger.debug("CHANNEL READ EX: " + chunk.toString(Charsets.UTF_8));
                        this.outboundChannel.writeAndFlush(this.channelBuffer).addListener(new ChannelFutureListener(){

                            @Override
                            public void operationComplete(ChannelFuture future) throws Exception {
                                if (future.isSuccess()) {
                                    DirectProxyUpstreamHandler.this.channelRead(ctx, chunk);
                                } else {
                                    DirectProxyUpstreamHandler.this.logger.warn("Failed to write to: " + DirectProxyUpstreamHandler.this.remoteSocketAddress, future.cause());
                                    future.channel().close();
                                }
                            }
                        });
                    }
                }
            } else {
                this.bufferedMode = false;
                if (this.outboundChannel.isActive()) {
                    this.logger.debug("CHANNEL READ NOT-BUFFERING: " + chunk.toString(Charsets.UTF_8));
                    this.outboundChannel.writeAndFlush(chunk).addListener(new ChannelFutureListener(){

                        @Override
                        public void operationComplete(ChannelFuture future) throws Exception {
                            if (future.isSuccess()) {
                                ctx.channel().read();
                            } else {
                                DirectProxyUpstreamHandler.this.logger.warn("Failed to write to: " + DirectProxyUpstreamHandler.this.remoteSocketAddress, future.cause());
                                future.channel().close();
                            }
                        }
                    });
                }
            }
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.logger.warn("Exception caught by http direct proxy handler closing pipeline", cause);
        Channel ch = ctx.channel();
        if (ch.isActive()) {
            ch.writeAndFlush(Unpooled.EMPTY_BUFFER).addListener(ChannelFutureListener.CLOSE);
        }
    }
}

