/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.junit;

import com.google.common.annotations.VisibleForTesting;
import java.lang.reflect.Field;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.mockserver.client.server.MockServerClient;
import org.mockserver.integration.ClientAndServer;
import org.mockserver.socket.PortFactory;

public class MockServerRule
implements TestRule {
    private static ClientAndServer perTestSuiteClientAndServer;
    private final Object target;
    private final Integer httpPort;
    private final Integer httpsPort;
    private final boolean perTestSuite;
    private ClientAndServerFactory clientAndServerFactory;

    public MockServerRule(Object target) {
        this(PortFactory.findFreePort(), target);
    }

    public MockServerRule(Object target, boolean perTestSuite) {
        this(PortFactory.findFreePort(), target, perTestSuite);
    }

    public MockServerRule(Integer httpPort, Object target) {
        this(httpPort, null, target, false);
    }

    public MockServerRule(Integer httpPort, Object target, boolean perTestSuite) {
        this(httpPort, null, target, perTestSuite);
    }

    public MockServerRule(Integer httpPort, Integer httpsPort, Object target, boolean perTestSuite) {
        this.httpPort = httpPort;
        this.httpsPort = httpsPort;
        this.target = target;
        this.perTestSuite = perTestSuite;
        this.clientAndServerFactory = new ClientAndServerFactory(httpPort, httpsPort);
    }

    public Integer getHttpPort() {
        return this.httpPort;
    }

    public Integer getHttpsPort() {
        return this.httpsPort;
    }

    public Statement apply(Statement base, Description description) {
        return this.statement(base);
    }

    private Statement statement(final Statement base) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                ClientAndServer clientAndServer;
                if (MockServerRule.this.perTestSuite) {
                    if (perTestSuiteClientAndServer == null) {
                        perTestSuiteClientAndServer = MockServerRule.this.clientAndServerFactory.newClientAndServer();
                        Runtime.getRuntime().addShutdownHook(new Thread(){

                            @Override
                            public void run() {
                                perTestSuiteClientAndServer.stop();
                            }
                        });
                    }
                    clientAndServer = perTestSuiteClientAndServer;
                } else {
                    clientAndServer = MockServerRule.this.clientAndServerFactory.newClientAndServer();
                }
                MockServerRule.this.setMockServerClient(MockServerRule.this.target, clientAndServer);
                try {
                    base.evaluate();
                }
                finally {
                    if (!MockServerRule.this.perTestSuite) {
                        clientAndServer.stop();
                    }
                }
            }
        };
    }

    private void setMockServerClient(Object target, ClientAndServer clientAndServer) {
        for (Field field : target.getClass().getDeclaredFields()) {
            if (!field.getType().equals(MockServerClient.class)) continue;
            field.setAccessible(true);
            try {
                field.set(target, (Object)clientAndServer);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error setting MockServerClient field on " + target.getClass().getName(), e);
            }
        }
    }

    @VisibleForTesting
    class ClientAndServerFactory {
        private final Integer httpPort;
        private final Integer httpsPort;

        public ClientAndServerFactory(Integer httpPort, Integer httpsPort) {
            this.httpPort = httpPort;
            this.httpsPort = httpsPort;
        }

        public ClientAndServer newClientAndServer() {
            if (this.httpsPort == null) {
                return ClientAndServer.startClientAndServer(this.httpPort);
            }
            return ClientAndServer.startClientAndServer(this.httpPort, this.httpsPort);
        }
    }
}

