/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.model;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.util.CharsetUtil;
import java.util.List;
import java.util.Map;
import org.mockserver.url.URLParser;

public class NettyHttpRequest
extends DefaultHttpRequest {
    private final String path;
    private final Map<String, List<String>> parameters;
    private boolean secure;
    private ByteBuf content;

    public NettyHttpRequest(HttpVersion httpVersion, HttpMethod method, String uri, boolean secure) {
        super(httpVersion, method, uri);
        QueryStringDecoder queryStringDecoder = new QueryStringDecoder(uri);
        this.path = URLParser.returnPath((String)queryStringDecoder.path());
        this.parameters = queryStringDecoder.parameters();
        this.secure = secure;
    }

    public void content(ByteBuf content) {
        if (this.content == null) {
            this.content = Unpooled.copiedBuffer((ByteBuf)content);
        } else if (this.content.isWritable(content.readableBytes())) {
            this.content.writeBytes(content);
        } else {
            this.content = Unpooled.copiedBuffer((ByteBuf[])new ByteBuf[]{this.content, content});
        }
    }

    public ByteBuf content() {
        return this.content;
    }

    public String path() {
        return this.path;
    }

    public Map<String, List<String>> parameters() {
        return this.parameters;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public boolean matches(HttpMethod method, String path) {
        return this.getMethod() == method && this.path.equals(path);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("NettyHttpRequest => {");
        sb.append("path='").append(this.path).append('\'');
        sb.append(", parameters=").append(this.parameters);
        sb.append(", secure=").append(this.secure);
        sb.append(", content=").append(this.content != null ? new String(Unpooled.copiedBuffer((ByteBuf)this.content).array(), CharsetUtil.UTF_8) : "");
        sb.append('}');
        return sb.toString();
    }
}

