/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mockserver;

import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.util.CharsetUtil;
import java.util.List;
import java.util.Map;
import org.mockserver.url.URLParser;

public class MappedRequest {
    private final HttpMethod method;
    private final String path;
    private final String content;
    private final Map<String, List<String>> parameters;

    public MappedRequest(FullHttpRequest request) {
        this.method = request.getMethod();
        QueryStringDecoder queryStringDecoder = new QueryStringDecoder(request.getUri());
        this.path = URLParser.returnPath((String)queryStringDecoder.path());
        this.parameters = queryStringDecoder.parameters();
        this.content = request.content() != null ? request.content().toString(CharsetUtil.UTF_8) : "";
    }

    public boolean matches(HttpMethod method, String path) {
        return this.method.equals((Object)method) && this.path.equals(path);
    }

    public HttpMethod method() {
        return this.method;
    }

    public String content() {
        return this.content;
    }

    public Map<String, List<String>> parameters() {
        return this.parameters;
    }
}

