/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.proxy.direct;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.mockserver.logging.LoggingHandler;
import org.mockserver.proxy.http.HttpProxy;
import org.mockserver.proxy.relay.DownstreamProxyRelayHandler;
import org.mockserver.proxy.relay.UpstreamProxyRelayHandler;
import org.mockserver.proxy.unification.PortUnificationHandler;
import org.mockserver.socket.SSLFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectProxyUpstreamHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public DirectProxyUpstreamHandler() {
        super(false);
    }

    public void channelRead0(final ChannelHandlerContext ctx, final FullHttpRequest request) throws Exception {
        Channel inboundChannel = ctx.channel();
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)inboundChannel.eventLoop())).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel socketChannel) throws Exception {
                ChannelPipeline downstreamPipeline = socketChannel.pipeline();
                if (PortUnificationHandler.isSslEnabled(ctx)) {
                    downstreamPipeline.addLast(new ChannelHandler[]{new SslHandler(SSLFactory.createClientSSLEngine())});
                }
                if (DirectProxyUpstreamHandler.this.logger.isDebugEnabled()) {
                    downstreamPipeline.addLast(new ChannelHandler[]{new LoggingHandler("                -->")});
                }
                downstreamPipeline.addLast(new ChannelHandler[]{new HttpClientCodec()});
                downstreamPipeline.addLast(new ChannelHandler[]{new HttpContentDecompressor()});
                downstreamPipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(Integer.MAX_VALUE)});
                downstreamPipeline.addLast(new ChannelHandler[]{new DownstreamProxyRelayHandler(ctx.channel(), DirectProxyUpstreamHandler.this.logger)});
                ChannelPipeline upstreamPipeline = ctx.channel().pipeline();
                if (DirectProxyUpstreamHandler.this.logger.isDebugEnabled()) {
                    upstreamPipeline.addLast(new ChannelHandler[]{new LoggingHandler("<-- ")});
                }
                upstreamPipeline.addLast(new ChannelHandler[]{new UpstreamProxyRelayHandler((Channel)socketChannel, DirectProxyUpstreamHandler.this.logger)});
            }
        });
        final InetSocketAddress remoteSocket = (InetSocketAddress)ctx.channel().attr(HttpProxy.REMOTE_SOCKET).get();
        bootstrap.connect((SocketAddress)remoteSocket).addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    future.channel().writeAndFlush((Object)request);
                } else {
                    DirectProxyUpstreamHandler.this.logger.error("Exception while connecting to ", (Object)remoteSocket);
                    DirectProxyUpstreamHandler.closeOnFlush(ctx.channel());
                }
            }
        });
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        DirectProxyUpstreamHandler.closeOnFlush(ctx.channel());
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.logger.error("Exception while reading from channel", cause);
        DirectProxyUpstreamHandler.closeOnFlush(ctx.channel());
    }

    public static void closeOnFlush(Channel ch) {
        if (ch != null && ch.isActive()) {
            ch.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }
}

