/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.proxy.socks;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.socks.SocksAuthResponse;
import io.netty.handler.codec.socks.SocksAuthScheme;
import io.netty.handler.codec.socks.SocksAuthStatus;
import io.netty.handler.codec.socks.SocksCmdRequest;
import io.netty.handler.codec.socks.SocksCmdRequestDecoder;
import io.netty.handler.codec.socks.SocksCmdType;
import io.netty.handler.codec.socks.SocksInitResponse;
import io.netty.handler.codec.socks.SocksRequest;
import org.mockserver.proxy.socks.SocksConnectHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocksProxyHandler
extends SimpleChannelInboundHandler<SocksRequest> {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public SocksProxyHandler() {
        super(false);
    }

    protected void channelRead0(ChannelHandlerContext ctx, SocksRequest socksRequest) {
        switch (socksRequest.requestType()) {
            case INIT: {
                ctx.pipeline().addFirst(new ChannelHandler[]{new SocksCmdRequestDecoder()});
                ctx.write((Object)new SocksInitResponse(SocksAuthScheme.NO_AUTH));
                break;
            }
            case AUTH: {
                ctx.pipeline().addFirst(new ChannelHandler[]{new SocksCmdRequestDecoder()});
                ctx.write((Object)new SocksAuthResponse(SocksAuthStatus.SUCCESS));
                break;
            }
            case CMD: {
                SocksCmdRequest req = (SocksCmdRequest)socksRequest;
                if (req.cmdType() == SocksCmdType.CONNECT) {
                    ctx.pipeline().addLast(new ChannelHandler[]{new SocksConnectHandler()});
                    ctx.pipeline().remove((ChannelHandler)this);
                    ctx.fireChannelRead((Object)socksRequest);
                    break;
                }
                ctx.close();
                break;
            }
            case UNKNOWN: {
                ctx.close();
            }
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (!cause.getMessage().contains("Connection reset by peer")) {
            this.logger.warn("Exception caught by MockServer handler closing pipeline", cause);
        }
        ctx.close();
    }
}

