/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.netty.proxy.relay;

import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import org.mockserver.exception.ExceptionHandling;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.model.Protocol;
import org.mockserver.netty.unification.PortUnificationHandler;
import org.mockserver.socket.tls.SniHandler;
import org.slf4j.event.Level;

public class UpstreamProxyRelayHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private final MockServerLogger mockServerLogger;
    private final Channel upstreamChannel;
    private final Channel downstreamChannel;

    public UpstreamProxyRelayHandler(MockServerLogger mockServerLogger, Channel upstreamChannel, Channel downstreamChannel) {
        super(false);
        this.upstreamChannel = upstreamChannel;
        this.downstreamChannel = downstreamChannel;
        this.mockServerLogger = mockServerLogger;
    }

    public void channelActive(ChannelHandlerContext ctx) {
        ctx.read();
        ctx.write((Object)Unpooled.EMPTY_BUFFER);
    }

    public void channelRead0(ChannelHandlerContext ctx, FullHttpRequest request) {
        if (PortUnificationHandler.isSslEnabledDownstream(this.upstreamChannel) && this.downstreamChannel.pipeline().get(SslHandler.class) == null) {
            this.downstreamChannel.pipeline().addFirst(new ChannelHandler[]{PortUnificationHandler.nettySslContextFactory(ctx.channel()).createClientSslContext(true, Protocol.HTTP_2.equals((Object)SniHandler.getALPNProtocol((MockServerLogger)this.mockServerLogger, (ChannelHandlerContext)ctx))).newHandler(ctx.alloc())});
        }
        this.downstreamChannel.writeAndFlush((Object)request).addListener((GenericFutureListener)((ChannelFutureListener)future -> {
            if (future.isSuccess()) {
                ctx.channel().read();
            } else {
                if (this.isNotSocketClosedException(future.cause())) {
                    this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception while returning response for request \"" + request.method() + " " + request.uri() + "\"").setThrowable(future.cause()));
                }
                future.channel().close();
            }
        }));
    }

    private boolean isNotSocketClosedException(Throwable cause) {
        return !(cause instanceof ClosedChannelException) && !(cause instanceof ClosedSelectorException);
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        ExceptionHandling.closeOnFlush((Channel)this.downstreamChannel);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (ExceptionHandling.connectionClosedException((Throwable)cause)) {
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception caught by upstream relay handler -> closing pipeline " + ctx.channel()).setThrowable(cause));
        }
        ExceptionHandling.closeOnFlush((Channel)ctx.channel());
    }
}

