/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.matchers.RegexStringMatcher;
import org.mockserver.model.NottableString;

class CaseInsensitiveNottableRegexListHashMap
extends LinkedHashMap<NottableString, List<NottableString>>
implements Map<NottableString, List<NottableString>> {
    private final RegexStringMatcher regexStringMatcher;

    CaseInsensitiveNottableRegexListHashMap(MockServerLogger mockServerLogger) {
        this.regexStringMatcher = new RegexStringMatcher(mockServerLogger);
    }

    @Override
    public synchronized boolean containsKey(Object key) {
        boolean result = false;
        if (key instanceof NottableString) {
            if (super.containsKey(key)) {
                result = true;
            } else {
                for (NottableString keyToCompare : this.keySet()) {
                    if (!this.regexStringMatcher.matches((NottableString)key, keyToCompare, true)) continue;
                    result = true;
                    break;
                }
            }
        } else if (key instanceof String) {
            result = this.containsKey(NottableString.string((String)key));
        }
        return result;
    }

    @Override
    public synchronized List<NottableString> get(Object key) {
        if (key instanceof NottableString) {
            for (Map.Entry entry : this.entrySet()) {
                if (!this.regexStringMatcher.matches((NottableString)key, (NottableString)entry.getKey(), true)) continue;
                return (List)entry.getValue();
            }
        } else if (key instanceof String) {
            return this.get(NottableString.string((String)key));
        }
        return null;
    }

    public synchronized Collection<List<NottableString>> getAll(Object key) {
        ArrayList<List<NottableString>> values = new ArrayList<List<NottableString>>();
        if (key instanceof NottableString) {
            for (Map.Entry entry : this.entrySet()) {
                if (!this.regexStringMatcher.matches((NottableString)key, (NottableString)entry.getKey(), true)) continue;
                values.add((List<NottableString>)entry.getValue());
            }
        } else if (key instanceof String) {
            return this.getAll(NottableString.string((String)key));
        }
        return values;
    }

    @Override
    public synchronized List<NottableString> put(String key, List<NottableString> value) {
        return super.put(NottableString.string(key), value);
    }

    @Override
    public synchronized List<NottableString> remove(Object key) {
        ArrayList<NottableString> values = new ArrayList<NottableString>();
        if (key instanceof NottableString) {
            for (Map.Entry entry : new HashSet(this.entrySet())) {
                if (!this.regexStringMatcher.matches((NottableString)key, (NottableString)entry.getKey(), true)) continue;
                values.addAll((Collection)super.remove(entry.getKey()));
            }
        } else if (key instanceof String) {
            return this.remove(NottableString.string((String)key));
        }
        return values;
    }
}

