/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import org.mockserver.collections.CaseInsensitiveRegexHashMap;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.matchers.NotMatcher;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.KeysAndValues;
import org.slf4j.event.Level;

public class HashMapMatcher
extends NotMatcher<KeysAndValues> {
    private final MockServerLogger mockServerLogger;
    private final CaseInsensitiveRegexHashMap hashMap;

    public HashMapMatcher(MockServerLogger mockServerLogger, KeysAndValues keysAndValues) {
        this.mockServerLogger = mockServerLogger;
        this.hashMap = keysAndValues != null ? keysAndValues.toCaseInsensitiveRegexMultiMap(mockServerLogger) : null;
    }

    @Override
    public boolean matches(HttpRequest context, KeysAndValues values) {
        boolean result;
        if (this.hashMap == null || this.hashMap.isEmpty()) {
            result = true;
        } else if (values == null || values.isEmpty()) {
            result = this.hashMap.allKeysNotted();
        } else if (values.toCaseInsensitiveRegexMultiMap(this.mockServerLogger).containsAll(this.hashMap)) {
            result = true;
        } else {
            this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.DEBUG).setLogLevel(Level.DEBUG).setHttpRequest(context).setMessageFormat("Map {} is not a subset of {}").setArguments(this.hashMap, values));
            result = false;
        }
        return this.not != result;
    }
}

