/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.netty.handler.codec.http.QueryStringDecoder;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.matchers.BodyMatcher;
import org.mockserver.matchers.MultiValueMapMatcher;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.Parameter;
import org.mockserver.model.Parameters;
import org.slf4j.event.Level;

public class ParameterStringMatcher
extends BodyMatcher<String> {
    private static final String[] EXCLUDED_FIELDS = new String[]{"key", "mockServerLogger"};
    private final MockServerLogger mockServerLogger;
    private final MultiValueMapMatcher matcher;

    public ParameterStringMatcher(MockServerLogger mockServerLogger, Parameters parameters) {
        this.mockServerLogger = mockServerLogger;
        this.matcher = new MultiValueMapMatcher(mockServerLogger, parameters);
    }

    @Override
    public boolean matches(HttpRequest context, String matched) {
        boolean result = false;
        if (this.matcher.matches(context, this.parseString(matched))) {
            result = true;
        }
        if (!result) {
            this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.DEBUG).setLogLevel(Level.DEBUG).setHttpRequest(context).setMessageFormat("Failed to perform parameter match {} with {}").setArguments(matched, this.matcher));
        }
        return this.not != result;
    }

    private Parameters parseString(String matched) {
        return (Parameters)new Parameters(new Parameter[0]).withEntries(new QueryStringDecoder("?" + matched).parameters());
    }

    @Override
    @JsonIgnore
    protected String[] fieldsExcludedFromEqualsAndHashCode() {
        return EXCLUDED_FIELDS;
    }
}

