/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.matchers.BodyMatcher;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.NottableString;
import org.slf4j.event.Level;

public class RegexStringMatcher
extends BodyMatcher<NottableString> {
    private static final String[] EXCLUDED_FIELDS = new String[]{"key", "mockServerLogger"};
    private final MockServerLogger mockServerLogger;
    private final NottableString matcher;

    public RegexStringMatcher(MockServerLogger mockServerLogger) {
        this.mockServerLogger = mockServerLogger;
        this.matcher = null;
    }

    public RegexStringMatcher(MockServerLogger mockServerLogger, String matcher) {
        this.mockServerLogger = mockServerLogger;
        this.matcher = NottableString.string(matcher);
    }

    public RegexStringMatcher(MockServerLogger mockServerLogger, NottableString matcher) {
        this.mockServerLogger = mockServerLogger;
        this.matcher = matcher;
    }

    public boolean matches(String matched) {
        return this.matches((HttpRequest)null, NottableString.string(matched));
    }

    @Override
    public boolean matches(HttpRequest context, NottableString matched) {
        boolean result = false;
        if (this.matches(this.matcher.getValue(), matched.getValue(), false)) {
            result = true;
        }
        if (!result) {
            this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.DEBUG).setLogLevel(Level.DEBUG).setHttpRequest(context).setMessageFormat("Failed to perform regex match {} with {}").setArguments(matched, this.matcher));
        }
        return matched.isNot() == (this.matcher.isNot() == (this.not != result));
    }

    public boolean matches(NottableString matcher, NottableString matched, boolean ignoreCase) {
        if (matcher.isNot() && matched.isNot()) {
            return this.matchesInternal(matcher, matched, ignoreCase);
        }
        return (matcher.isNot() || matched.isNot()) ^ this.matchesInternal(matcher, matched, ignoreCase);
    }

    private boolean matchesInternal(NottableString matcher, NottableString matched, boolean ignoreCase) {
        if (matcher.isBlank()) {
            return true;
        }
        if (matched.getValue() != null) {
            if (matched.getValue().equals(matcher.getValue())) {
                return true;
            }
            try {
                if (matched.matches(matcher.getValue())) {
                    return true;
                }
            }
            catch (PatternSyntaxException pse) {
                this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.TRACE).setLogLevel(Level.TRACE).setMessageFormat("Error while matching regex [" + matcher + "] for string [" + matched + "] " + pse.getMessage()));
            }
            try {
                if (matcher.matches(matched.getValue())) {
                    return true;
                }
            }
            catch (PatternSyntaxException pse) {
                this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.TRACE).setLogLevel(Level.TRACE).setMessageFormat("Error while matching regex [" + matched + "] for string [" + matcher + "] " + pse.getMessage()));
            }
            if (ignoreCase) {
                if (matched.getValue().equalsIgnoreCase(matcher.getValue())) {
                    return true;
                }
                try {
                    if (matched.matchesIgnoreCase(matcher.getValue())) {
                        return true;
                    }
                }
                catch (PatternSyntaxException pse) {
                    this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.TRACE).setLogLevel(Level.TRACE).setMessageFormat("Error while matching regex [" + matcher + "] for string [" + matched + "] and ignoring case " + pse.getMessage()));
                }
                try {
                    if (matcher.matchesIgnoreCase(matched.getValue())) {
                        return true;
                    }
                }
                catch (PatternSyntaxException pse) {
                    this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.TRACE).setLogLevel(Level.TRACE).setMessageFormat("Error while matching regex [" + matched + "] for string [" + matcher + "] and ignoring case " + pse.getMessage()));
                }
            }
        }
        return false;
    }

    public boolean matches(String matcher, String matched, boolean ignoreCase) {
        if (StringUtils.isBlank(matcher)) {
            return true;
        }
        if (matched != null) {
            if (matched.equals(matcher)) {
                return true;
            }
            try {
                if (matched.matches(matcher)) {
                    return true;
                }
            }
            catch (PatternSyntaxException pse) {
                this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.TRACE).setLogLevel(Level.TRACE).setMessageFormat("Error while matching regex [" + matcher + "] for string [" + matched + "] " + pse.getMessage()));
            }
            try {
                if (matcher.matches(matched)) {
                    return true;
                }
            }
            catch (PatternSyntaxException pse) {
                this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.TRACE).setLogLevel(Level.TRACE).setMessageFormat("Error while matching regex [" + matched + "] for string [" + matcher + "] " + pse.getMessage()));
            }
            if (ignoreCase) {
                if (matched.equalsIgnoreCase(matcher)) {
                    return true;
                }
                try {
                    if (matched.toLowerCase().matches(matcher.toLowerCase())) {
                        return true;
                    }
                }
                catch (PatternSyntaxException pse) {
                    this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.TRACE).setLogLevel(Level.TRACE).setMessageFormat("Error while matching regex [" + matcher.toLowerCase() + "] for string [" + matched.toLowerCase() + "] " + pse.getMessage()));
                }
                try {
                    if (matcher.toLowerCase().matches(matched.toLowerCase())) {
                        return true;
                    }
                }
                catch (PatternSyntaxException pse) {
                    this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.TRACE).setLogLevel(Level.TRACE).setMessageFormat("Error while matching regex [" + matched.toLowerCase() + "] for string [" + matcher.toLowerCase() + "] " + pse.getMessage()));
                }
            }
        }
        return false;
    }

    @Override
    @JsonIgnore
    protected String[] fieldsExcludedFromEqualsAndHashCode() {
        return EXCLUDED_FIELDS;
    }
}

