/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.character.Character;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.model.HttpResponse;
import org.mockserver.serialization.JsonArraySerializer;
import org.mockserver.serialization.ObjectMapperFactory;
import org.mockserver.serialization.Serializer;
import org.mockserver.serialization.model.HttpResponseDTO;
import org.mockserver.validator.jsonschema.JsonSchemaHttpResponseValidator;
import org.slf4j.event.Level;

public class HttpResponseSerializer
implements Serializer<HttpResponse> {
    private final MockServerLogger mockServerLogger;
    private ObjectMapper objectMapper = ObjectMapperFactory.createObjectMapper(new JsonSerializer[0]);
    private JsonArraySerializer jsonArraySerializer = new JsonArraySerializer();
    private JsonSchemaHttpResponseValidator httpResponseValidator;

    public HttpResponseSerializer(MockServerLogger mockServerLogger) {
        this.mockServerLogger = mockServerLogger;
        this.httpResponseValidator = JsonSchemaHttpResponseValidator.jsonSchemaHttpResponseValidator(mockServerLogger);
    }

    @Override
    public String serialize(HttpResponse httpResponse) {
        try {
            return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(new HttpResponseDTO(httpResponse));
        }
        catch (Exception e) {
            this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setLogLevel(Level.ERROR).setMessageFormat("Exception while serializing httpResponse to JSON with value " + httpResponse).setThrowable(e));
            throw new RuntimeException("Exception while serializing httpResponse to JSON with value " + httpResponse, e);
        }
    }

    @Override
    public String serialize(List<HttpResponse> httpResponses) {
        return this.serialize(httpResponses.toArray(new HttpResponse[0]));
    }

    @Override
    public String serialize(HttpResponse ... httpResponses) {
        try {
            if (httpResponses != null && httpResponses.length > 0) {
                HttpResponseDTO[] httpResponseDTOs = new HttpResponseDTO[httpResponses.length];
                for (int i = 0; i < httpResponses.length; ++i) {
                    httpResponseDTOs[i] = new HttpResponseDTO(httpResponses[i]);
                }
                return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(httpResponseDTOs);
            }
            return "[]";
        }
        catch (Exception e) {
            this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setLogLevel(Level.ERROR).setMessageFormat("Exception while serializing HttpResponse to JSON with value " + Arrays.asList(httpResponses)).setThrowable(e));
            throw new RuntimeException("Exception while serializing HttpResponse to JSON with value " + Arrays.asList(httpResponses), e);
        }
    }

    @Override
    public HttpResponse deserialize(String jsonHttpResponse) {
        String validationErrors;
        if (StringUtils.isBlank(jsonHttpResponse)) {
            throw new IllegalArgumentException("1 error:" + Character.NEW_LINE + " - a response is required but value was \"" + jsonHttpResponse + "\"");
        }
        if (jsonHttpResponse.contains("\"httpResponse\"")) {
            try {
                JsonNode jsonNode = this.objectMapper.readTree(jsonHttpResponse);
                if (jsonNode.has("httpResponse")) {
                    jsonHttpResponse = jsonNode.get("httpResponse").toString();
                }
            }
            catch (Exception e) {
                this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setLogLevel(Level.ERROR).setMessageFormat("exception while parsing {} for HttpResponse").setArguments(jsonHttpResponse).setThrowable(e));
                throw new RuntimeException("Exception while parsing [" + jsonHttpResponse + "] for HttpResponse", e);
            }
        }
        if ((validationErrors = this.httpResponseValidator.isValid(jsonHttpResponse)).isEmpty()) {
            HttpResponse httpResponse = null;
            try {
                HttpResponseDTO httpResponseDTO = this.objectMapper.readValue(jsonHttpResponse, HttpResponseDTO.class);
                if (httpResponseDTO != null) {
                    httpResponse = httpResponseDTO.buildObject();
                }
            }
            catch (Exception e) {
                this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setLogLevel(Level.ERROR).setMessageFormat("exception while parsing {} for HttpResponse").setArguments(jsonHttpResponse).setThrowable(e));
                throw new RuntimeException("Exception while parsing [" + jsonHttpResponse + "] for HttpResponse", e);
            }
            return httpResponse;
        }
        this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setLogLevel(Level.ERROR).setHttpRequest(null).setMessageFormat("validation failed:{}response:{}").setArguments(validationErrors, jsonHttpResponse));
        throw new IllegalArgumentException(validationErrors);
    }

    @Override
    public Class<HttpResponse> supportsType() {
        return HttpResponse.class;
    }

    public HttpResponse[] deserializeArray(String jsonHttpResponses) {
        ArrayList<HttpResponse> httpResponses = new ArrayList<HttpResponse>();
        if (StringUtils.isBlank(jsonHttpResponses)) {
            throw new IllegalArgumentException("1 error:" + Character.NEW_LINE + " - a response or response array is required but value was \"" + jsonHttpResponses + "\"");
        }
        List<String> jsonResponseList = this.jsonArraySerializer.returnJSONObjects(jsonHttpResponses);
        if (jsonResponseList.isEmpty()) {
            throw new IllegalArgumentException("1 error:" + Character.NEW_LINE + " - a response or array of response is required");
        }
        ArrayList<String> validationErrorsList = new ArrayList<String>();
        for (String jsonExpecation : jsonResponseList) {
            try {
                httpResponses.add(this.deserialize(jsonExpecation));
            }
            catch (IllegalArgumentException iae) {
                validationErrorsList.add(iae.getMessage());
            }
        }
        if (!validationErrorsList.isEmpty()) {
            throw new IllegalArgumentException((validationErrorsList.size() > 1 ? "[" : "") + Joiner.on("," + Character.NEW_LINE).join(validationErrorsList) + (validationErrorsList.size() > 1 ? "]" : ""));
        }
        return httpResponses.toArray(new HttpResponse[0]);
    }
}

