/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization.java;

import com.google.common.base.Strings;
import org.mockserver.character.Character;
import org.mockserver.model.HttpOverrideForwardedRequest;
import org.mockserver.serialization.java.DelayToJavaSerializer;
import org.mockserver.serialization.java.HttpRequestToJavaSerializer;
import org.mockserver.serialization.java.ToJavaSerializer;

public class HttpOverrideForwardRequestToJavaSerializer
implements ToJavaSerializer<HttpOverrideForwardedRequest> {
    @Override
    public String serialize(int numberOfSpacesToIndent, HttpOverrideForwardedRequest httpForward) {
        StringBuffer output = new StringBuffer();
        if (httpForward != null) {
            this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append("forwardOverriddenRequest()");
            if (httpForward.getHttpRequest() != null) {
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append(".withRequest(").append(new HttpRequestToJavaSerializer().serialize(numberOfSpacesToIndent + 1, httpForward.getHttpRequest())).append(")");
            }
            if (httpForward.getDelay() != null) {
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append(".withDelay(").append(new DelayToJavaSerializer().serialize(0, httpForward.getDelay())).append(")");
            }
        }
        return output.toString();
    }

    private StringBuffer appendNewLineAndIndent(int numberOfSpacesToIndent, StringBuffer output) {
        return output.append(Character.NEW_LINE).append(Strings.padStart("", numberOfSpacesToIndent, ' '));
    }
}

