/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization.java;

import com.google.common.base.Strings;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.mockserver.character.Character;
import org.mockserver.model.BinaryBody;
import org.mockserver.model.Cookie;
import org.mockserver.model.Header;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.JsonBody;
import org.mockserver.model.JsonPathBody;
import org.mockserver.model.JsonSchemaBody;
import org.mockserver.model.ObjectWithReflectiveEqualsHashCodeToString;
import org.mockserver.model.Parameter;
import org.mockserver.model.ParameterBody;
import org.mockserver.model.RegexBody;
import org.mockserver.model.StringBody;
import org.mockserver.model.XPathBody;
import org.mockserver.model.XmlBody;
import org.mockserver.model.XmlSchemaBody;
import org.mockserver.serialization.Base64Converter;
import org.mockserver.serialization.java.CookieToJavaSerializer;
import org.mockserver.serialization.java.HeaderToJavaSerializer;
import org.mockserver.serialization.java.MultiValueToJavaSerializer;
import org.mockserver.serialization.java.ParameterToJavaSerializer;
import org.mockserver.serialization.java.ToJavaSerializer;

public class HttpRequestToJavaSerializer
implements ToJavaSerializer<HttpRequest> {
    private final Base64Converter base64Converter = new Base64Converter();

    public String serialize(List<HttpRequest> httpRequests) {
        StringBuilder output = new StringBuilder();
        for (HttpRequest httpRequest : httpRequests) {
            output.append(this.serialize(0, httpRequest));
            output.append(";");
            output.append(Character.NEW_LINE);
        }
        return output.toString();
    }

    @Override
    public String serialize(int numberOfSpacesToIndent, HttpRequest request) {
        StringBuffer output = new StringBuffer();
        if (request != null) {
            this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output);
            output.append("request()");
            if (StringUtils.isNotBlank(request.getMethod().getValue())) {
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output);
                output.append(".withMethod(\"").append(request.getMethod().getValue()).append("\")");
            }
            if (StringUtils.isNotBlank(request.getPath().getValue())) {
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output);
                output.append(".withPath(\"").append(request.getPath().getValue()).append("\")");
            }
            this.outputHeaders(numberOfSpacesToIndent + 1, output, request.getHeaderList());
            this.outputCookies(numberOfSpacesToIndent + 1, output, request.getCookieList());
            this.outputQueryStringParameter(numberOfSpacesToIndent + 1, output, request.getQueryStringParameterList());
            if (request.isSecure() != null) {
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output);
                output.append(".withSecure(").append(request.isSecure().toString()).append(")");
            }
            if (request.isKeepAlive() != null) {
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output);
                output.append(".withKeepAlive(").append(request.isKeepAlive().toString()).append(")");
            }
            if (request.getBody() != null) {
                if (request.getBody() instanceof JsonBody) {
                    this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output);
                    output.append(".withBody(");
                    JsonBody jsonBody = (JsonBody)request.getBody();
                    output.append("new JsonBody(\"").append(StringEscapeUtils.escapeJava(jsonBody.getValue())).append("\", JsonBodyMatchType.").append((Object)jsonBody.getMatchType()).append(")");
                    output.append(")");
                } else if (request.getBody() instanceof JsonPathBody) {
                    this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output);
                    output.append(".withBody(");
                    JsonPathBody jsonPathBody = (JsonPathBody)request.getBody();
                    output.append("new JsonPathBody(\"").append(StringEscapeUtils.escapeJava(jsonPathBody.getValue())).append("\")");
                    output.append(")");
                } else if (request.getBody() instanceof JsonSchemaBody) {
                    this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output);
                    output.append(".withBody(");
                    JsonSchemaBody jsonSchemaBody = (JsonSchemaBody)request.getBody();
                    output.append("new JsonSchemaBody(\"").append(StringEscapeUtils.escapeJava(jsonSchemaBody.getValue())).append("\")");
                    output.append(")");
                } else if (request.getBody() instanceof XmlBody) {
                    this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output);
                    output.append(".withBody(");
                    XmlBody xmlBody = (XmlBody)request.getBody();
                    output.append("new XmlBody(\"").append(StringEscapeUtils.escapeJava(xmlBody.getValue())).append("\")");
                    output.append(")");
                } else if (request.getBody() instanceof XPathBody) {
                    this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output);
                    output.append(".withBody(");
                    XPathBody xPathBody = (XPathBody)request.getBody();
                    output.append("new XPathBody(\"").append(StringEscapeUtils.escapeJava(xPathBody.getValue())).append("\")");
                    output.append(")");
                } else if (request.getBody() instanceof XmlSchemaBody) {
                    this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output);
                    output.append(".withBody(");
                    XmlSchemaBody xmlSchemaBody = (XmlSchemaBody)request.getBody();
                    output.append("new XmlSchemaBody(\"").append(StringEscapeUtils.escapeJava(xmlSchemaBody.getValue())).append("\")");
                    output.append(")");
                } else if (request.getBody() instanceof RegexBody) {
                    this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output);
                    output.append(".withBody(");
                    RegexBody regexBody = (RegexBody)request.getBody();
                    output.append("new RegexBody(\"").append(StringEscapeUtils.escapeJava(regexBody.getValue())).append("\")");
                    output.append(")");
                } else if (request.getBody() instanceof StringBody) {
                    this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output);
                    output.append(".withBody(");
                    StringBody stringBody = (StringBody)request.getBody();
                    output.append("new StringBody(\"").append(StringEscapeUtils.escapeJava(stringBody.getValue())).append("\")");
                    output.append(")");
                } else if (request.getBody() instanceof ParameterBody) {
                    this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output);
                    output.append(".withBody(");
                    this.appendNewLineAndIndent((numberOfSpacesToIndent + 2) * 8, output);
                    output.append("new ParameterBody(");
                    List<Parameter> bodyParameters = ((ParameterBody)request.getBody()).getValue().getEntries();
                    output.append(new ParameterToJavaSerializer().serializeAsJava(numberOfSpacesToIndent + 3, bodyParameters));
                    this.appendNewLineAndIndent((numberOfSpacesToIndent + 2) * 8, output);
                    output.append(")");
                    this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output);
                    output.append(")");
                } else if (request.getBody() instanceof BinaryBody) {
                    this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output);
                    BinaryBody body = (BinaryBody)request.getBody();
                    output.append(".withBody(new Base64Converter().base64StringToBytes(\"").append(this.base64Converter.bytesToBase64String(body.getRawBytes())).append("\"))");
                }
            }
        }
        return output.toString();
    }

    private void outputQueryStringParameter(int numberOfSpacesToIndent, StringBuffer output, List<Parameter> parameters) {
        if (parameters.size() > 0) {
            this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append(".withQueryStringParameters(");
            this.appendObject(numberOfSpacesToIndent, output, new ParameterToJavaSerializer(), parameters);
            this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append(")");
        }
    }

    private void outputCookies(int numberOfSpacesToIndent, StringBuffer output, List<Cookie> cookies) {
        if (cookies.size() > 0) {
            this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append(".withCookies(");
            this.appendObject(numberOfSpacesToIndent, output, new CookieToJavaSerializer(), cookies);
            this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append(")");
        }
    }

    private void outputHeaders(int numberOfSpacesToIndent, StringBuffer output, List<Header> headers) {
        if (headers.size() > 0) {
            this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append(".withHeaders(");
            this.appendObject(numberOfSpacesToIndent, output, new HeaderToJavaSerializer(), headers);
            this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append(")");
        }
    }

    private <T extends ObjectWithReflectiveEqualsHashCodeToString> void appendObject(int numberOfSpacesToIndent, StringBuffer output, MultiValueToJavaSerializer<T> toJavaSerializer, List<T> objects) {
        output.append(toJavaSerializer.serializeAsJava(numberOfSpacesToIndent + 1, objects));
    }

    private StringBuffer appendNewLineAndIndent(int numberOfSpacesToIndent, StringBuffer output) {
        return output.append(Character.NEW_LINE).append(Strings.padStart("", numberOfSpacesToIndent, ' '));
    }
}

