/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization.model;

import java.util.ArrayList;
import java.util.List;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.ObjectWithReflectiveEqualsHashCodeToString;
import org.mockserver.serialization.model.DTO;
import org.mockserver.serialization.model.HttpRequestDTO;
import org.mockserver.verify.VerificationSequence;

public class VerificationSequenceDTO
extends ObjectWithReflectiveEqualsHashCodeToString
implements DTO<VerificationSequence> {
    private List<HttpRequestDTO> httpRequests = new ArrayList<HttpRequestDTO>();

    public VerificationSequenceDTO(VerificationSequence verification) {
        if (verification != null) {
            for (HttpRequest httpRequest : verification.getHttpRequests()) {
                this.httpRequests.add(new HttpRequestDTO(httpRequest));
            }
        }
    }

    public VerificationSequenceDTO() {
    }

    @Override
    public VerificationSequence buildObject() {
        ArrayList<HttpRequest> httpRequests = new ArrayList<HttpRequest>();
        for (HttpRequestDTO httpRequest : this.httpRequests) {
            httpRequests.add(httpRequest.buildObject());
        }
        return new VerificationSequence().withRequests(httpRequests);
    }

    public List<HttpRequestDTO> getHttpRequests() {
        return this.httpRequests;
    }

    public VerificationSequenceDTO setHttpRequests(List<HttpRequestDTO> httpRequests) {
        this.httpRequests = httpRequests;
        return this;
    }
}

