/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.unification;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.ReplayingDecoder;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.socksx.v4.Socks4ServerDecoder;
import io.netty.handler.codec.socksx.v4.Socks4ServerEncoder;
import io.netty.handler.codec.socksx.v5.Socks5InitialRequestDecoder;
import io.netty.handler.codec.socksx.v5.Socks5ServerEncoder;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.AttributeKey;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections4.KeyValue;
import org.apache.commons.collections4.keyvalue.DefaultKeyValue;
import org.mockserver.callback.CallbackWebSocketServerHandler;
import org.mockserver.codec.MockServerServerCodec;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.dashboard.DashboardWebSocketServerHandler;
import org.mockserver.exception.ExceptionHandler;
import org.mockserver.lifecycle.LifeCycle;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.LoggingHandler;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.mock.HttpStateHandler;
import org.mockserver.mock.action.ActionHandler;
import org.mockserver.mockserver.MockServerHandler;
import org.mockserver.proxy.socks.Socks4ProxyHandler;
import org.mockserver.proxy.socks.Socks5ProxyHandler;
import org.mockserver.proxy.socks.SocksDetector;
import org.mockserver.socket.tls.NettySslContextFactory;
import org.mockserver.socket.tls.SniHandler;
import org.mockserver.unification.HttpContentLengthRemover;
import org.slf4j.event.Level;

public class PortUnificationHandler
extends ReplayingDecoder<Void> {
    private static final AttributeKey<Boolean> SSL_ENABLED_UPSTREAM = AttributeKey.valueOf("PROXY_SSL_ENABLED_UPSTREAM");
    private static final AttributeKey<Boolean> SSL_ENABLED_DOWNSTREAM = AttributeKey.valueOf("SSL_ENABLED_DOWNSTREAM");
    private static final Map<KeyValue<InetSocketAddress, String>, Set<String>> localAddressesCache = new ConcurrentHashMap<KeyValue<InetSocketAddress, String>, Set<String>>();
    protected final MockServerLogger mockServerLogger;
    private final LoggingHandler loggingHandler = new LoggingHandler(PortUnificationHandler.class);
    private final HttpContentLengthRemover httpContentLengthRemover = new HttpContentLengthRemover();
    private final LifeCycle server;
    private final HttpStateHandler httpStateHandler;
    private final ActionHandler actionHandler;
    private final NettySslContextFactory nettySslContextFactory;

    public PortUnificationHandler(LifeCycle server, HttpStateHandler httpStateHandler, ActionHandler actionHandler, NettySslContextFactory nettySslContextFactory) {
        this.server = server;
        this.mockServerLogger = httpStateHandler.getMockServerLogger();
        this.httpStateHandler = httpStateHandler;
        this.actionHandler = actionHandler;
        this.nettySslContextFactory = nettySslContextFactory;
    }

    public static void enableSslUpstreamAndDownstream(Channel channel) {
        channel.attr(SSL_ENABLED_UPSTREAM).set(Boolean.TRUE);
        channel.attr(SSL_ENABLED_DOWNSTREAM).set(Boolean.TRUE);
    }

    public static boolean isSslEnabledUpstream(Channel channel) {
        if (channel.attr(SSL_ENABLED_UPSTREAM).get() != null) {
            return channel.attr(SSL_ENABLED_UPSTREAM).get();
        }
        return false;
    }

    public static void enableSslDownstream(Channel channel) {
        channel.attr(SSL_ENABLED_DOWNSTREAM).set(Boolean.TRUE);
    }

    public static void disableSslDownstream(Channel channel) {
        channel.attr(SSL_ENABLED_DOWNSTREAM).set(Boolean.FALSE);
    }

    public static boolean isSslEnabledDownstream(Channel channel) {
        if (channel.attr(SSL_ENABLED_DOWNSTREAM).get() != null) {
            return channel.attr(SSL_ENABLED_DOWNSTREAM).get();
        }
        return false;
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf msg, List<Object> out) {
        if (SocksDetector.isSocks4(msg, this.actualReadableBytes())) {
            this.enableSocks4(ctx, msg);
        } else if (SocksDetector.isSocks5(msg, this.actualReadableBytes())) {
            this.enableSocks5(ctx, msg);
        } else if (this.isSsl(msg)) {
            this.enableSsl(ctx, msg);
        } else if (this.isHttp(msg)) {
            this.switchToHttp(ctx, msg);
        } else {
            msg.clear();
            ctx.flush();
            ctx.close();
        }
        this.addLoggingHandler(ctx);
    }

    private void addLoggingHandler(ChannelHandlerContext ctx) {
        if (MockServerLogger.isEnabled(Level.TRACE)) {
            this.loggingHandler.addLoggingHandler(ctx);
        }
    }

    private boolean isSsl(ByteBuf buf) {
        return SslHandler.isEncrypted(buf);
    }

    private boolean isHttp(ByteBuf msg) {
        String method = msg.toString(msg.readerIndex(), 8, StandardCharsets.US_ASCII);
        return method.startsWith("GET ") || method.startsWith("POST ") || method.startsWith("PUT ") || method.startsWith("HEAD ") || method.startsWith("OPTIONS ") || method.startsWith("PATCH ") || method.startsWith("DELETE ") || method.startsWith("TRACE ") || method.startsWith("CONNECT ");
    }

    private void enableSocks4(ChannelHandlerContext ctx, ByteBuf msg) {
        this.enableSocks(ctx, msg, new Socks4ProxyHandler(this.server, this.mockServerLogger), Socks4ServerEncoder.INSTANCE, new Socks4ServerDecoder());
    }

    private void enableSocks5(ChannelHandlerContext ctx, ByteBuf msg) {
        this.enableSocks(ctx, msg, new Socks5ProxyHandler(this.server, this.mockServerLogger), Socks5ServerEncoder.DEFAULT, new Socks5InitialRequestDecoder());
    }

    private void enableSocks(ChannelHandlerContext ctx, ByteBuf msg, ChannelHandler ... channelHandlers) {
        ChannelPipeline pipeline = ctx.pipeline();
        for (ChannelHandler channelHandler : channelHandlers) {
            pipeline.addFirst(channelHandler);
        }
        ctx.pipeline().fireChannelRead(msg.readBytes(this.actualReadableBytes()));
    }

    private void enableSsl(ChannelHandlerContext ctx, ByteBuf msg) {
        ChannelPipeline pipeline = ctx.pipeline();
        pipeline.addFirst(new SniHandler(this.nettySslContextFactory));
        PortUnificationHandler.enableSslUpstreamAndDownstream(ctx.channel());
        ctx.pipeline().fireChannelRead(msg.readBytes(this.actualReadableBytes()));
    }

    private void switchToHttp(ChannelHandlerContext ctx, ByteBuf msg) {
        ChannelPipeline pipeline = ctx.pipeline();
        this.addLastIfNotPresent(pipeline, new HttpServerCodec(ConfigurationProperties.maxInitialLineLength(), ConfigurationProperties.maxHeaderSize(), ConfigurationProperties.maxChunkSize()));
        this.addLastIfNotPresent(pipeline, new HttpContentDecompressor());
        this.addLastIfNotPresent(pipeline, this.httpContentLengthRemover);
        this.addLastIfNotPresent(pipeline, new HttpObjectAggregator(Integer.MAX_VALUE));
        if (MockServerLogger.isEnabled(Level.TRACE)) {
            this.addLastIfNotPresent(pipeline, this.loggingHandler);
        }
        this.addLastIfNotPresent(pipeline, new CallbackWebSocketServerHandler(this.httpStateHandler));
        this.addLastIfNotPresent(pipeline, new DashboardWebSocketServerHandler(this.httpStateHandler));
        this.addLastIfNotPresent(pipeline, new MockServerServerCodec(this.mockServerLogger, PortUnificationHandler.isSslEnabledUpstream(ctx.channel())));
        this.addLastIfNotPresent(pipeline, new MockServerHandler(this.server, this.httpStateHandler, this.actionHandler));
        pipeline.remove(this);
        ctx.channel().attr(MockServerHandler.LOCAL_HOST_HEADERS).set(this.getLocalAddresses(ctx));
        ctx.fireChannelRead(msg.readBytes(this.actualReadableBytes()));
    }

    private Set<String> getLocalAddresses(ChannelHandlerContext ctx) {
        String portExtension;
        InetSocketAddress inetSocketAddress;
        DefaultKeyValue<InetSocketAddress, String> cacheKey;
        SocketAddress localAddress = ctx.channel().localAddress();
        Set<String> localAddresses = null;
        if (localAddress instanceof InetSocketAddress && (localAddresses = localAddressesCache.get(cacheKey = new DefaultKeyValue<InetSocketAddress, String>(inetSocketAddress = (InetSocketAddress)localAddress, portExtension = this.calculatePortExtension(inetSocketAddress, PortUnificationHandler.isSslEnabledUpstream(ctx.channel()))))) == null) {
            localAddresses = this.calculateLocalAddresses(inetSocketAddress, portExtension);
            localAddressesCache.put(cacheKey, localAddresses);
        }
        return localAddresses == null ? Collections.emptySet() : localAddresses;
    }

    private String calculatePortExtension(InetSocketAddress inetSocketAddress, boolean sslEnabledUpstream) {
        String portExtension = inetSocketAddress.getPort() == 443 && sslEnabledUpstream || inetSocketAddress.getPort() == 80 && !sslEnabledUpstream ? "" : ":" + inetSocketAddress.getPort();
        return portExtension;
    }

    private Set<String> calculateLocalAddresses(InetSocketAddress localAddress, String portExtension) {
        InetAddress socketAddress = localAddress.getAddress();
        HashSet<String> localAddresses = new HashSet<String>();
        localAddresses.add(socketAddress.getHostAddress() + portExtension);
        localAddresses.add(socketAddress.getCanonicalHostName() + portExtension);
        localAddresses.add(socketAddress.getHostName() + portExtension);
        localAddresses.add("localhost" + portExtension);
        localAddresses.add("127.0.0.1" + portExtension);
        return Collections.unmodifiableSet(localAddresses);
    }

    private void addLastIfNotPresent(ChannelPipeline pipeline, ChannelHandler channelHandler) {
        if (pipeline.get(channelHandler.getClass()) == null) {
            pipeline.addLast(channelHandler);
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (ExceptionHandler.shouldNotIgnoreException(cause)) {
            this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setLogLevel(Level.ERROR).setMessageFormat("Exception caught by port unification handler -> closing pipeline " + ctx.channel()).setThrowable(cause));
        }
        ExceptionHandler.closeOnFlush(ctx.channel());
    }
}

