/*
 * Decompiled with CFR 0.152.
 */
package org.mockftpserver.fake.command;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.mockftpserver.core.command.Command;
import org.mockftpserver.core.session.Session;
import org.mockftpserver.core.util.StringUtil;
import org.mockftpserver.fake.command.AbstractFakeCommandHandler;
import org.mockftpserver.fake.filesystem.FileSystemEntry;

public class ListCommandHandler
extends AbstractFakeCommandHandler {
    protected void handle(Command command, Session session) {
        this.verifyLoggedIn(session);
        this.sendReply(session, 150);
        String path = this.getRealPath(session, command.getParameter(0));
        if (this.getFileSystem().exists(path)) {
            this.replyCodeForFileSystemException = 550;
            this.verifyReadPermission(session, path);
        }
        this.replyCodeForFileSystemException = 451;
        List fileEntries = this.getFileSystem().listFiles(path);
        Iterator iter = fileEntries.iterator();
        ArrayList<String> lines = new ArrayList<String>();
        while (iter.hasNext()) {
            FileSystemEntry entry = (FileSystemEntry)iter.next();
            lines.add(this.getFileSystem().formatDirectoryListing(entry));
        }
        String result = StringUtil.join(lines, this.endOfLine());
        result = result + (result.length() > 0 ? this.endOfLine() : "");
        session.openDataConnection();
        this.LOG.info((Object)("Sending [" + result + "]"));
        session.sendData(result.getBytes(), result.length());
        session.closeDataConnection();
        this.sendReply(session, 226);
    }
}

