/*
 * Decompiled with CFR 0.152.
 */
package org.mockftpserver.fake.filesystem;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mockftpserver.core.util.Assert;
import org.mockftpserver.core.util.PatternUtil;
import org.mockftpserver.core.util.StringUtil;
import org.mockftpserver.fake.filesystem.DirectoryEntry;
import org.mockftpserver.fake.filesystem.DirectoryListingFormatter;
import org.mockftpserver.fake.filesystem.FileSystem;
import org.mockftpserver.fake.filesystem.FileSystemEntry;
import org.mockftpserver.fake.filesystem.FileSystemException;
import org.mockftpserver.fake.filesystem.InvalidFilenameException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFakeFileSystem
implements FileSystem {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractFakeFileSystem.class);
    private boolean createParentDirectoriesAutomatically = true;
    private String systemName;
    private DirectoryListingFormatter directoryListingFormatter;
    private Map entries = new HashMap();

    public boolean isCreateParentDirectoriesAutomatically() {
        return this.createParentDirectoriesAutomatically;
    }

    public void setCreateParentDirectoriesAutomatically(boolean createParentDirectoriesAutomatically) {
        this.createParentDirectoriesAutomatically = createParentDirectoriesAutomatically;
    }

    public DirectoryListingFormatter getDirectoryListingFormatter() {
        return this.directoryListingFormatter;
    }

    public void setDirectoryListingFormatter(DirectoryListingFormatter directoryListingFormatter) {
        this.directoryListingFormatter = directoryListingFormatter;
    }

    public void setEntries(List entriesToAdd) {
        for (FileSystemEntry entry : entriesToAdd) {
            this.add(entry);
        }
    }

    @Override
    public void add(FileSystemEntry entry) {
        String path = entry.getPath();
        this.checkForInvalidFilename(path);
        if (this.getEntry(path) != null) {
            throw new FileSystemException(path, "filesystem.pathAlreadyExists");
        }
        if (!this.parentDirectoryExists(path)) {
            String parent = this.getParent(path);
            if (this.createParentDirectoriesAutomatically) {
                this.add(new DirectoryEntry(parent));
            } else {
                throw new FileSystemException(parent, "filesystem.parentDirectoryDoesNotExist");
            }
        }
        if (entry.getLastModified() == null) {
            entry.setLastModified(new Date());
        }
        this.entries.put(this.getFileSystemEntryKey(path), entry);
        entry.lockPath();
    }

    @Override
    public boolean delete(String path) {
        Assert.notNull(path, "path");
        if (this.getEntry(path) != null && !this.hasChildren(path)) {
            this.removeEntry(path);
            return true;
        }
        return false;
    }

    @Override
    public boolean exists(String path) {
        Assert.notNull(path, "path");
        return this.getEntry(path) != null;
    }

    @Override
    public boolean isDirectory(String path) {
        Assert.notNull(path, "path");
        FileSystemEntry entry = this.getEntry(path);
        return entry != null && entry.isDirectory();
    }

    @Override
    public boolean isFile(String path) {
        Assert.notNull(path, "path");
        FileSystemEntry entry = this.getEntry(path);
        return entry != null && !entry.isDirectory();
    }

    @Override
    public List listFiles(String path) {
        if (this.isFile(path)) {
            return Collections.singletonList(this.getEntry(path));
        }
        ArrayList<FileSystemEntry> entryList = new ArrayList<FileSystemEntry>();
        List children = this.children(path);
        for (String childPath : children) {
            FileSystemEntry fileSystemEntry = this.getEntry(childPath);
            entryList.add(fileSystemEntry);
        }
        return entryList;
    }

    @Override
    public List listNames(String path) {
        if (this.isFile(path)) {
            return Collections.singletonList(this.getName(path));
        }
        ArrayList<String> filenames = new ArrayList<String>();
        List children = this.children(path);
        for (String childPath : children) {
            FileSystemEntry fileSystemEntry = this.getEntry(childPath);
            filenames.add(fileSystemEntry.getName());
        }
        return filenames;
    }

    @Override
    public void rename(String fromPath, String toPath) {
        Assert.notNull(toPath, "toPath");
        Assert.notNull(fromPath, "fromPath");
        FileSystemEntry entry = this.getRequiredEntry(fromPath);
        if (this.exists(toPath)) {
            throw new FileSystemException(toPath, "filesystem.alreadyExists");
        }
        String normalizedFromPath = this.normalize(fromPath);
        String normalizedToPath = this.normalize(toPath);
        if (!entry.isDirectory()) {
            this.renamePath(entry, normalizedToPath);
            return;
        }
        if (normalizedToPath.startsWith(normalizedFromPath + this.getSeparator())) {
            throw new FileSystemException(toPath, "filesystem.renameFailed");
        }
        this.add(new DirectoryEntry(normalizedToPath));
        List children = this.descendants(fromPath);
        Collections.sort(children);
        for (String childPath : children) {
            FileSystemEntry child = this.getRequiredEntry(childPath);
            String normalizedChildPath = this.normalize(child.getPath());
            Assert.isTrue(normalizedChildPath.startsWith(normalizedFromPath), "Starts with FROM path");
            String childToPath = normalizedToPath + normalizedChildPath.substring(normalizedFromPath.length());
            this.renamePath(child, childToPath);
        }
        Assert.isTrue(this.children(normalizedFromPath).isEmpty(), "Must have no children: " + normalizedFromPath);
        this.removeEntry(normalizedFromPath);
    }

    public String toString() {
        return this.getClass().getName() + this.entries;
    }

    @Override
    public String formatDirectoryListing(FileSystemEntry fileSystemEntry) {
        Assert.notNull(this.directoryListingFormatter, "directoryListingFormatter");
        Assert.notNull(fileSystemEntry, "fileSystemEntry");
        return this.directoryListingFormatter.format(fileSystemEntry);
    }

    @Override
    public String path(String path1, String path2) {
        StringBuffer buf = new StringBuffer();
        if (path1 != null && path1.length() > 0) {
            buf.append(path1);
        }
        if (path2 != null && path2.length() > 0) {
            if (path1 != null && path1.length() > 0 && !this.isSeparator(path1.charAt(path1.length() - 1)) && !this.isSeparator(path2.charAt(0))) {
                buf.append(this.getSeparator());
            }
            buf.append(path2);
        }
        return this.normalize(buf.toString());
    }

    @Override
    public String getParent(String path) {
        List parts = this.normalizedComponents(path);
        if (parts.size() < 2) {
            return null;
        }
        parts.remove(parts.size() - 1);
        return this.componentsToPath(parts);
    }

    public String getName(String path) {
        Assert.notNull(path, "path");
        String normalized = this.normalize(path);
        int separatorIndex = normalized.lastIndexOf(this.getSeparator());
        return separatorIndex == -1 ? normalized : normalized.substring(separatorIndex + 1);
    }

    @Override
    public FileSystemEntry getEntry(String path) {
        return (FileSystemEntry)this.entries.get(this.getFileSystemEntryKey(path));
    }

    @Override
    public String getSystemName() {
        return this.systemName;
    }

    public void setSystemName(String systemName) {
        this.systemName = systemName;
    }

    protected abstract boolean isValidName(String var1);

    protected abstract char getSeparatorChar();

    protected abstract boolean isRoot(String var1);

    protected abstract boolean isSeparator(char var1);

    protected String getSeparator() {
        return Character.toString(this.getSeparatorChar());
    }

    protected String getFileSystemEntryKey(String path) {
        return this.normalize(path);
    }

    protected String normalize(String path) {
        return this.componentsToPath(this.normalizedComponents(path));
    }

    protected void checkForInvalidFilename(String path) {
        if (!this.isValidName(path)) {
            throw new InvalidFilenameException(path);
        }
    }

    protected void renamePath(FileSystemEntry entry, String toPath) {
        String normalizedFrom = this.normalize(entry.getPath());
        String normalizedTo = this.normalize(toPath);
        LOG.info("renaming from [" + normalizedFrom + "] to [" + normalizedTo + "]");
        FileSystemEntry newEntry = entry.cloneWithNewPath(normalizedTo);
        this.add(newEntry);
        this.removeEntry(normalizedFrom);
    }

    protected FileSystemEntry getRequiredEntry(String path) {
        FileSystemEntry entry = this.getEntry(path);
        if (entry == null) {
            LOG.error("Path does not exist: " + path);
            throw new FileSystemException(this.normalize(path), "filesystem.doesNotExist");
        }
        return entry;
    }

    protected List normalizedComponents(String path) {
        Assert.notNull(path, "path");
        char otherSeparator = this.getSeparatorChar() == '/' ? (char)'\\' : '/';
        String p = path.replace(otherSeparator, this.getSeparatorChar());
        if (p.equals(this.getSeparator())) {
            return Collections.singletonList("");
        }
        ArrayList<String> result = new ArrayList<String>();
        if (p.length() > 0) {
            String[] parts = p.split("\\" + this.getSeparator());
            for (int i = 0; i < parts.length; ++i) {
                String part = parts[i];
                if (part.equals("..")) {
                    result.remove(result.size() - 1);
                    continue;
                }
                if (part.equals(".")) continue;
                result.add(part);
            }
        }
        return result;
    }

    protected String componentsToPath(List components) {
        String first;
        if (components.size() == 1 && ((first = (String)components.get(0)).length() == 0 || this.isRoot(first))) {
            return first + this.getSeparator();
        }
        return StringUtil.join(components, this.getSeparator());
    }

    @Override
    public boolean isAbsolute(String path) {
        return this.isValidName(path);
    }

    private boolean pathExists(String path) {
        return this.getEntry(path) != null;
    }

    private boolean parentDirectoryExists(String path) {
        String parent = this.getParent(path);
        return parent == null || this.pathExists(parent);
    }

    private boolean hasChildren(String path) {
        if (!this.isDirectory(path)) {
            return false;
        }
        String key = this.getFileSystemEntryKey(path);
        for (String p : this.entries.keySet()) {
            if (!p.startsWith(key) || key.equals(p)) continue;
            return true;
        }
        return false;
    }

    private List descendants(String path) {
        if (this.isDirectory(path)) {
            String normalizedPath = this.getFileSystemEntryKey(path);
            String separator = normalizedPath.endsWith(this.getSeparator()) ? "" : this.getSeparator();
            String normalizedDirPrefix = normalizedPath + separator;
            ArrayList<String> descendants = new ArrayList<String>();
            for (Map.Entry mapEntry : this.entries.entrySet()) {
                String p = (String)mapEntry.getKey();
                if (!p.startsWith(normalizedDirPrefix) || normalizedPath.equals(p)) continue;
                FileSystemEntry fileSystemEntry = (FileSystemEntry)mapEntry.getValue();
                descendants.add(fileSystemEntry.getPath());
            }
            return descendants;
        }
        return Collections.EMPTY_LIST;
    }

    private List children(String path) {
        String lastComponent = this.getName(path);
        boolean containsWildcards = PatternUtil.containsWildcards(lastComponent);
        String dir = containsWildcards ? this.getParent(path) : path;
        String pattern = containsWildcards ? PatternUtil.convertStringWithWildcardsToRegex(this.getName(path)) : null;
        LOG.debug("path=" + path + " lastComponent=" + lastComponent + " containsWildcards=" + containsWildcards + " dir=" + dir + " pattern=" + pattern);
        List descendents = this.descendants(dir);
        ArrayList<String> children = new ArrayList<String>();
        String normalizedDir = this.normalize(dir);
        for (String descendentPath : descendents) {
            boolean patternEmpty;
            boolean bl = patternEmpty = pattern == null || pattern.length() == 0;
            if (!normalizedDir.equals(this.getParent(descendentPath)) || !patternEmpty && !this.getName(descendentPath).matches(pattern)) continue;
            children.add(descendentPath);
        }
        return children;
    }

    private void removeEntry(String path) {
        this.entries.remove(this.getFileSystemEntryKey(path));
    }
}

