/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.kotlin;

import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mockito.Mockito;
import org.mockito.exceptions.misusing.NotAMockException;
import org.mockito.kotlin.MockitoKotlinException;
import org.mockito.kotlin.MockitoKt;
import org.mockito.kotlin.internal.CreateInstanceKt;
import org.mockito.stubbing.OngoingStubbing;
import org.mockito.stubbing.Stubber;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0004J\u001f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\n0\t\"\u0004\b\u0001\u0010\n2\u0006\u0010\u000b\u001a\u0002H\n\u00a2\u0006\u0002\u0010\fJ+\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\n0\t\"\u0004\b\u0001\u0010\n2\u0017\u0010\u000b\u001a\u0013\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H\n0\r\u00a2\u0006\u0002\b\u000eJ;\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\n0\t\"\n\b\u0001\u0010\n\u0018\u0001*\u00020\u00022\u001b\b\b\u0010\u000b\u001a\u0015\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u0001H\n0\r\u00a2\u0006\u0002\b\u000eH\u0086\b\u00f8\u0001\u0000J?\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\n0\t\"\b\b\u0001\u0010\n*\u00020\u00022\u0019\u0010\u000b\u001a\u0015\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u0001H\n0\r\u00a2\u0006\u0002\b\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\n0\u0011J#\u0010\b\u001a\u00020\u0012*\u00020\u00132\u0017\u0010\u000b\u001a\u0013\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00120\r\u00a2\u0006\u0002\b\u000eJW\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\n0\t\"\b\b\u0001\u0010\u0001*\u00020\u0002\"\u0004\b\u0002\u0010\n*\b\u0012\u0004\u0012\u0002H\u00010\u00002'\u0010\u0015\u001a#\b\u0001\u0012\u0004\u0012\u0002H\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\n0\u0017\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0016\u00a2\u0006\u0002\b\u000e\u00f8\u0001\u0001\u00a2\u0006\u0002\u0010\u0018R\u0013\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0007\u001a\u0004\b\u0005\u0010\u0006\u0082\u0002\u000b\n\u0005\b\u009920\u0001\n\u0002\b\u0019\u00a8\u0006\u0019"}, d2={"Lorg/mockito/kotlin/KStubbing;", "T", "", "mock", "(Ljava/lang/Object;)V", "getMock", "()Ljava/lang/Object;", "Ljava/lang/Object;", "on", "Lorg/mockito/stubbing/OngoingStubbing;", "R", "methodCall", "(Ljava/lang/Object;)Lorg/mockito/stubbing/OngoingStubbing;", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "onGeneric", "c", "Lkotlin/reflect/KClass;", "", "Lorg/mockito/stubbing/Stubber;", "onBlocking", "m", "Lkotlin/Function2;", "Lkotlin/coroutines/Continuation;", "(Lorg/mockito/kotlin/KStubbing;Lkotlin/jvm/functions/Function2;)Lorg/mockito/stubbing/OngoingStubbing;", "mockito-kotlin"})
public final class KStubbing<T> {
    @NotNull
    private final T mock;

    @NotNull
    public final <R> OngoingStubbing<R> on(R methodCall) {
        OngoingStubbing ongoingStubbing = Mockito.when(methodCall);
        Intrinsics.checkNotNullExpressionValue((Object)ongoingStubbing, (String)"Mockito.`when`(methodCall)");
        return ongoingStubbing;
    }

    @NotNull
    public final <R> OngoingStubbing<R> onGeneric(@NotNull Function1<? super T, ? extends R> methodCall, @NotNull KClass<R> c) {
        Object object;
        Intrinsics.checkNotNullParameter(methodCall, (String)"methodCall");
        Intrinsics.checkNotNullParameter(c, (String)"c");
        try {
            object = methodCall.invoke(this.mock);
        }
        catch (NullPointerException e) {
            object = CreateInstanceKt.createInstance(c);
        }
        Object r = object;
        OngoingStubbing ongoingStubbing = Mockito.when(r);
        Intrinsics.checkNotNullExpressionValue((Object)ongoingStubbing, (String)"Mockito.`when`(r)");
        return ongoingStubbing;
    }

    public final /* synthetic */ <R> OngoingStubbing<R> onGeneric(Function1<? super T, ? extends R> methodCall) {
        int $i$f$onGeneric = 0;
        Intrinsics.checkNotNullParameter(methodCall, (String)"methodCall");
        Intrinsics.reifiedOperationMarker((int)4, (String)"R");
        return this.onGeneric(methodCall, Reflection.getOrCreateKotlinClass(Object.class));
    }

    @NotNull
    public final <R> OngoingStubbing<R> on(@NotNull Function1<? super T, ? extends R> methodCall) {
        OngoingStubbing ongoingStubbing;
        Intrinsics.checkNotNullParameter(methodCall, (String)"methodCall");
        try {
            OngoingStubbing ongoingStubbing2 = Mockito.when((Object)methodCall.invoke(this.mock));
            Intrinsics.checkNotNullExpressionValue((Object)ongoingStubbing2, (String)"Mockito.`when`(mock.methodCall())");
            ongoingStubbing = ongoingStubbing2;
        }
        catch (NullPointerException e) {
            throw (Throwable)new MockitoKotlinException("NullPointerException thrown when stubbing.\nThis may be due to two reasons:\n\t- The method you're trying to stub threw an NPE: look at the stack trace below;\n\t- You're trying to stub a generic method: try `onGeneric` instead.", e);
        }
        return ongoingStubbing;
    }

    @NotNull
    public final <T, R> OngoingStubbing<R> onBlocking(@NotNull KStubbing<? extends T> $this$onBlocking, @NotNull Function2<? super T, ? super Continuation<? super R>, ? extends Object> m) {
        Intrinsics.checkNotNullParameter($this$onBlocking, (String)"$this$onBlocking");
        Intrinsics.checkNotNullParameter(m, (String)"m");
        Object object = BuildersKt.runBlocking$default(null, (Function2)new Function2<CoroutineScope, Continuation<? super OngoingStubbing<R>>, Object>($this$onBlocking, m, null){
            int label;
            final /* synthetic */ KStubbing $this_onBlocking;
            final /* synthetic */ Function2 $m;

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.$m.invoke(this.$this_onBlocking.getMock(), (Object)((Object)this));
                        if (object3 != object2) return Mockito.when((Object)object3);
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Mockito.when((Object)object3);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.$this_onBlocking = kStubbing;
                this.$m = function2;
                super(2, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkNotNullParameter(completion, (String)"completion");
                Function2<CoroutineScope, Continuation<? super OngoingStubbing<R>>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }, (int)1, null);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runBlocking { Mockito.`when`(mock.m()) }");
        return (OngoingStubbing)object;
    }

    public final void on(@NotNull Stubber $this$on, @NotNull Function1<? super T, Unit> methodCall) {
        Intrinsics.checkNotNullParameter((Object)$this$on, (String)"$this$on");
        Intrinsics.checkNotNullParameter(methodCall, (String)"methodCall");
        Object object = $this$on.when(this.mock);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"this.`when`(mock)");
        methodCall.invoke(object);
    }

    @NotNull
    public final T getMock() {
        return this.mock;
    }

    public KStubbing(@NotNull T mock) {
        Intrinsics.checkNotNullParameter(mock, (String)"mock");
        this.mock = mock;
        if (!MockitoKt.mockingDetails(this.mock).isMock()) {
            throw (Throwable)new NotAMockException("Stubbing target is not a mock!");
        }
    }
}

