/*
 * Decompiled with CFR 0.152.
 */
package jmetal.core;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import jmetal.core.Operator;
import jmetal.core.Problem;
import jmetal.core.SolutionSet;
import jmetal.util.JMException;

public abstract class Algorithm
implements Serializable {
    protected Problem problem_;
    protected Map<String, Operator> operators_ = null;
    protected Map<String, Object> inputParameters_ = null;
    protected Map<String, Object> outPutParameters_ = null;

    public Algorithm(Problem problem) {
        this.problem_ = problem;
    }

    public abstract SolutionSet execute() throws JMException, ClassNotFoundException;

    public void addOperator(String name, Operator operator) {
        if (this.operators_ == null) {
            this.operators_ = new HashMap<String, Operator>();
        }
        this.operators_.put(name, operator);
    }

    public Operator getOperator(String name) {
        return this.operators_.get(name);
    }

    public void setInputParameter(String name, Object object) {
        if (this.inputParameters_ == null) {
            this.inputParameters_ = new HashMap<String, Object>();
        }
        this.inputParameters_.put(name, object);
    }

    public Object getInputParameter(String name) {
        return this.inputParameters_.get(name);
    }

    public void setOutputParameter(String name, Object object) {
        if (this.outPutParameters_ == null) {
            this.outPutParameters_ = new HashMap<String, Object>();
        }
        this.outPutParameters_.put(name, object);
    }

    public Object getOutputParameter(String name) {
        if (this.outPutParameters_ != null) {
            return this.outPutParameters_.get(name);
        }
        return null;
    }

    public Problem getProblem() {
        return this.problem_;
    }
}

