/*
 * Decompiled with CFR 0.152.
 */
package jmetal.core;

import java.io.Serializable;
import jmetal.core.Problem;
import jmetal.core.SolutionType;
import jmetal.core.Variable;
import jmetal.encodings.variable.Binary;

public class Solution
implements Serializable {
    Problem problem_;
    private SolutionType type_;
    private Variable[] variable_;
    private double[] objective_;
    private int numberOfObjectives_;
    private double fitness_;
    private boolean marked_;
    private int rank_;
    private double overallConstraintViolation_;
    private int numberOfViolatedConstraints_;
    private int location_;
    private double kDistance_;
    private double crowdingDistance_;
    private double distanceToSolutionSet_;

    public Solution() {
        this.problem_ = null;
        this.marked_ = false;
        this.overallConstraintViolation_ = 0.0;
        this.numberOfViolatedConstraints_ = 0;
        this.type_ = null;
        this.variable_ = null;
        this.objective_ = null;
    }

    public Solution(int numberOfObjectives) {
        this.numberOfObjectives_ = numberOfObjectives;
        this.objective_ = new double[numberOfObjectives];
    }

    public Solution(Problem problem) throws ClassNotFoundException {
        this.problem_ = problem;
        this.type_ = problem.getSolutionType();
        this.numberOfObjectives_ = problem.getNumberOfObjectives();
        this.objective_ = new double[this.numberOfObjectives_];
        this.fitness_ = 0.0;
        this.kDistance_ = 0.0;
        this.crowdingDistance_ = 0.0;
        this.distanceToSolutionSet_ = Double.POSITIVE_INFINITY;
        this.variable_ = this.type_.createVariables();
    }

    public static Solution getNewSolution(Problem problem) throws ClassNotFoundException {
        return new Solution(problem);
    }

    public Solution(Problem problem, Variable[] variables) {
        this.problem_ = problem;
        this.type_ = problem.getSolutionType();
        this.numberOfObjectives_ = problem.getNumberOfObjectives();
        this.objective_ = new double[this.numberOfObjectives_];
        this.fitness_ = 0.0;
        this.kDistance_ = 0.0;
        this.crowdingDistance_ = 0.0;
        this.distanceToSolutionSet_ = Double.POSITIVE_INFINITY;
        this.variable_ = variables;
    }

    public Solution(Solution solution) {
        this.problem_ = solution.problem_;
        this.type_ = solution.type_;
        this.numberOfObjectives_ = solution.numberOfObjectives();
        this.objective_ = new double[this.numberOfObjectives_];
        for (int i = 0; i < this.objective_.length; ++i) {
            this.objective_[i] = solution.getObjective(i);
        }
        this.variable_ = this.type_.copyVariables(solution.variable_);
        this.overallConstraintViolation_ = solution.getOverallConstraintViolation();
        this.numberOfViolatedConstraints_ = solution.getNumberOfViolatedConstraint();
        this.distanceToSolutionSet_ = solution.getDistanceToSolutionSet();
        this.crowdingDistance_ = solution.getCrowdingDistance();
        this.kDistance_ = solution.getKDistance();
        this.fitness_ = solution.getFitness();
        this.marked_ = solution.isMarked();
        this.rank_ = solution.getRank();
        this.location_ = solution.getLocation();
    }

    public void setDistanceToSolutionSet(double distance) {
        this.distanceToSolutionSet_ = distance;
    }

    public double getDistanceToSolutionSet() {
        return this.distanceToSolutionSet_;
    }

    public void setKDistance(double distance) {
        this.kDistance_ = distance;
    }

    public double getKDistance() {
        return this.kDistance_;
    }

    public void setCrowdingDistance(double distance) {
        this.crowdingDistance_ = distance;
    }

    public double getCrowdingDistance() {
        return this.crowdingDistance_;
    }

    public void setFitness(double fitness) {
        this.fitness_ = fitness;
    }

    public double getFitness() {
        return this.fitness_;
    }

    public void setObjective(int i, double value) {
        this.objective_[i] = value;
    }

    public double getObjective(int i) {
        return this.objective_[i];
    }

    public int numberOfObjectives() {
        if (this.objective_ == null) {
            return 0;
        }
        return this.numberOfObjectives_;
    }

    public int numberOfVariables() {
        return this.problem_.getNumberOfVariables();
    }

    public String toString() {
        String aux = "";
        for (int i = 0; i < this.numberOfObjectives_; ++i) {
            aux = aux + this.getObjective(i) + " ";
        }
        return aux;
    }

    public Variable[] getDecisionVariables() {
        return this.variable_;
    }

    public void setDecisionVariables(Variable[] variables) {
        this.variable_ = variables;
    }

    public boolean isMarked() {
        return this.marked_;
    }

    public void marked() {
        this.marked_ = true;
    }

    public void unMarked() {
        this.marked_ = false;
    }

    public void setRank(int value) {
        this.rank_ = value;
    }

    public int getRank() {
        return this.rank_;
    }

    public void setOverallConstraintViolation(double value) {
        this.overallConstraintViolation_ = value;
    }

    public double getOverallConstraintViolation() {
        return this.overallConstraintViolation_;
    }

    public void setNumberOfViolatedConstraint(int value) {
        this.numberOfViolatedConstraints_ = value;
    }

    public int getNumberOfViolatedConstraint() {
        return this.numberOfViolatedConstraints_;
    }

    public void setLocation(int location) {
        this.location_ = location;
    }

    public int getLocation() {
        return this.location_;
    }

    public void setType(SolutionType type) {
        this.type_ = type;
    }

    public SolutionType getType() {
        return this.type_;
    }

    public double getAggregativeValue() {
        double value = 0.0;
        for (int i = 0; i < this.numberOfObjectives(); ++i) {
            value += this.getObjective(i);
        }
        return value;
    }

    public int getNumberOfBits() {
        int bits = 0;
        for (int i = 0; i < this.variable_.length; ++i) {
            try {
                if (this.variable_[i].getVariableType() != Class.forName("jmetal.base.variable.Binary") && this.variable_[i].getVariableType() != Class.forName("jmetal.base.variable.BinaryReal")) continue;
                bits += ((Binary)this.variable_[i]).getNumberOfBits();
                continue;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return bits;
    }
}

