/*
 * Decompiled with CFR 0.152.
 */
package jmetal.core;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import jmetal.core.Solution;
import jmetal.util.Configuration;

public class SolutionSet
implements Serializable {
    protected List<Solution> solutionsList_ = new ArrayList<Solution>();
    private int capacity_ = 0;

    public SolutionSet() {
    }

    public SolutionSet(int maximumSize) {
        this.capacity_ = maximumSize;
    }

    public boolean add(Solution solution) {
        if (this.solutionsList_.size() == this.capacity_) {
            Configuration.logger_.severe("The population is full");
            Configuration.logger_.severe("Capacity is : " + this.capacity_);
            Configuration.logger_.severe("\t Size is: " + this.size());
            return false;
        }
        this.solutionsList_.add(solution);
        return true;
    }

    public Solution get(int i) {
        if (i >= this.solutionsList_.size()) {
            throw new IndexOutOfBoundsException("Index out of Bound " + i);
        }
        return this.solutionsList_.get(i);
    }

    public int getMaxSize() {
        return this.capacity_;
    }

    public void sort(Comparator comparator) {
        if (comparator == null) {
            Configuration.logger_.severe("No criterium for compare exist");
            return;
        }
        Collections.sort(this.solutionsList_, comparator);
    }

    public int indexBest(Comparator comparator) {
        if (this.solutionsList_ == null || this.solutionsList_.isEmpty()) {
            return -1;
        }
        int index = 0;
        Solution bestKnown = this.solutionsList_.get(0);
        for (int i = 1; i < this.solutionsList_.size(); ++i) {
            Solution candidateSolution = this.solutionsList_.get(i);
            int flag = comparator.compare(bestKnown, candidateSolution);
            if (flag != -1) continue;
            index = i;
            bestKnown = candidateSolution;
        }
        return index;
    }

    public Solution best(Comparator comparator) {
        int indexBest = this.indexBest(comparator);
        if (indexBest < 0) {
            return null;
        }
        return this.solutionsList_.get(indexBest);
    }

    public int indexWorst(Comparator comparator) {
        if (this.solutionsList_ == null || this.solutionsList_.isEmpty()) {
            return -1;
        }
        int index = 0;
        Solution worstKnown = this.solutionsList_.get(0);
        for (int i = 1; i < this.solutionsList_.size(); ++i) {
            Solution candidateSolution = this.solutionsList_.get(i);
            int flag = comparator.compare(worstKnown, candidateSolution);
            if (flag != -1) continue;
            index = i;
            worstKnown = candidateSolution;
        }
        return index;
    }

    public Solution worst(Comparator comparator) {
        int index = this.indexWorst(comparator);
        if (index < 0) {
            return null;
        }
        return this.solutionsList_.get(index);
    }

    public int size() {
        return this.solutionsList_.size();
    }

    public void printObjectivesToFile(String path) {
        try {
            FileOutputStream fos = new FileOutputStream(path);
            OutputStreamWriter osw = new OutputStreamWriter(fos);
            BufferedWriter bw = new BufferedWriter(osw);
            for (int i = 0; i < this.solutionsList_.size(); ++i) {
                bw.write(this.solutionsList_.get(i).toString());
                bw.newLine();
            }
            bw.close();
        }
        catch (IOException e) {
            Configuration.logger_.severe("Error acceding to the file");
            e.printStackTrace();
        }
    }

    public void printVariablesToFile(String path) {
        try {
            FileOutputStream fos = new FileOutputStream(path);
            OutputStreamWriter osw = new OutputStreamWriter(fos);
            BufferedWriter bw = new BufferedWriter(osw);
            int numberOfVariables = this.solutionsList_.get(0).getDecisionVariables().length;
            for (int i = 0; i < this.solutionsList_.size(); ++i) {
                for (int j = 0; j < numberOfVariables; ++j) {
                    bw.write(this.solutionsList_.get(i).getDecisionVariables()[j].toString() + " ");
                }
                bw.newLine();
            }
            bw.close();
        }
        catch (IOException e) {
            Configuration.logger_.severe("Error acceding to the file");
            e.printStackTrace();
        }
    }

    public void clear() {
        this.solutionsList_.clear();
    }

    public void remove(int i) {
        if (i > this.solutionsList_.size() - 1) {
            Configuration.logger_.severe("Size is: " + this.size());
        }
        this.solutionsList_.remove(i);
    }

    public Iterator<Solution> iterator() {
        return this.solutionsList_.iterator();
    }

    public SolutionSet union(SolutionSet solutionSet) {
        int i;
        int newSize = this.size() + solutionSet.size();
        if (newSize < this.capacity_) {
            newSize = this.capacity_;
        }
        SolutionSet union = new SolutionSet(newSize);
        for (i = 0; i < this.size(); ++i) {
            union.add(this.get(i));
        }
        for (i = this.size(); i < this.size() + solutionSet.size(); ++i) {
            union.add(solutionSet.get(i - this.size()));
        }
        return union;
    }

    public void replace(int position, Solution solution) {
        if (position > this.solutionsList_.size()) {
            this.solutionsList_.add(solution);
        }
        this.solutionsList_.remove(position);
        this.solutionsList_.add(position, solution);
    }

    public double[][] writeObjectivesToMatrix() {
        if (this.size() == 0) {
            return null;
        }
        double[][] objectives = new double[this.size()][this.get(0).numberOfObjectives()];
        for (int i = 0; i < this.size(); ++i) {
            for (int j = 0; j < this.get(0).numberOfObjectives(); ++j) {
                objectives[i][j] = this.get(i).getObjective(j);
            }
        }
        return objectives;
    }
}

