/*
 * Decompiled with CFR 0.152.
 */
package jmetal.encodings.variable;

import jmetal.core.Problem;
import jmetal.core.Variable;
import jmetal.util.Configuration;
import jmetal.util.JMException;
import jmetal.util.PseudoRandom;

public class ArrayInt
extends Variable {
    Problem problem_;
    public int[] array_;
    public int size_;
    private int[] lowerBounds_;
    private int[] upperBounds_;

    public ArrayInt() {
        this.lowerBounds_ = null;
        this.upperBounds_ = null;
        this.size_ = 0;
        this.array_ = null;
        this.problem_ = null;
    }

    public ArrayInt(int size) {
        this.size_ = size;
        this.array_ = new int[this.size_];
        this.lowerBounds_ = new int[this.size_];
        this.upperBounds_ = new int[this.size_];
    }

    public ArrayInt(int size, double[] lowerBounds, double[] upperBounds) {
        this.size_ = size;
        this.array_ = new int[this.size_];
        this.lowerBounds_ = new int[this.size_];
        this.upperBounds_ = new int[this.size_];
        for (int i = 0; i < this.size_; ++i) {
            this.lowerBounds_[i] = (int)lowerBounds[i];
            this.upperBounds_[i] = (int)upperBounds[i];
            this.array_[i] = PseudoRandom.randInt(this.lowerBounds_[i], this.upperBounds_[i]);
        }
    }

    public ArrayInt(ArrayInt arrayInt) {
        this.size_ = arrayInt.size_;
        this.array_ = new int[this.size_];
        this.lowerBounds_ = new int[this.size_];
        this.upperBounds_ = new int[this.size_];
        for (int i = 0; i < this.size_; ++i) {
            this.array_[i] = arrayInt.array_[i];
            this.lowerBounds_[i] = arrayInt.lowerBounds_[i];
            this.upperBounds_[i] = arrayInt.upperBounds_[i];
        }
    }

    @Override
    public Variable deepCopy() {
        return new ArrayInt(this);
    }

    public int getLength() {
        return this.size_;
    }

    public int getValue(int index) throws JMException {
        if (index >= 0 && index < this.size_) {
            return this.array_[index];
        }
        Configuration.logger_.severe("jmetal.base.variable.ArrayInt.getValue: index value (" + index + ") invalid");
        throw new JMException("jmetal.base.variable.ArrayInt: index value (" + index + ") invalid");
    }

    public void setValue(int index, int value) throws JMException {
        if (index < 0 || index >= this.size_) {
            Configuration.logger_.severe("jmetal.base.variable.ArrayInt.setValue: index value (" + index + ") invalid");
            throw new JMException("jmetal.base.variable.ArrayInt: index value (" + index + ") invalid");
        }
        this.array_[index] = value;
    }

    public double getLowerBound(int index) throws JMException {
        if (index >= 0 && index < this.size_) {
            return this.lowerBounds_[index];
        }
        Configuration.logger_.severe("jmetal.base.variable.ArrayInt.getLowerBound: index value (" + index + ") invalid");
        throw new JMException("jmetal.base.variable.getLowerBound: index value (" + index + ") invalid");
    }

    public double getUpperBound(int index) throws JMException {
        if (index >= 0 && index < this.size_) {
            return this.upperBounds_[index];
        }
        Configuration.logger_.severe("jmetal.base.variable.ArrayInt.getUpperBound: index value (" + index + ") invalid");
        throw new JMException("jmetal.base.variable.getUpperBound: index value (" + index + ") invalid");
    }

    public String toString() {
        String string = "";
        for (int i = 0; i < this.size_; ++i) {
            string = string + this.array_[i] + " ";
        }
        return string;
    }
}

