/*
 * Decompiled with CFR 0.152.
 */
package jmetal.encodings.variable;

import jmetal.core.Problem;
import jmetal.core.Variable;
import jmetal.util.Configuration;
import jmetal.util.JMException;
import jmetal.util.PseudoRandom;

public class ArrayReal
extends Variable {
    Problem problem_;
    public Double[] array_;
    public int size_;

    public ArrayReal() {
        this.problem_ = null;
        this.size_ = 0;
        this.array_ = null;
    }

    public ArrayReal(int size, Problem problem) {
        this.problem_ = problem;
        this.size_ = size;
        this.array_ = new Double[this.size_];
        for (int i = 0; i < this.size_; ++i) {
            this.array_[i] = PseudoRandom.randDouble() * (this.problem_.getUpperLimit(i) - this.problem_.getLowerLimit(i)) + this.problem_.getLowerLimit(i);
        }
    }

    public ArrayReal(ArrayReal arrayReal) {
        this.problem_ = arrayReal.problem_;
        this.size_ = arrayReal.size_;
        this.array_ = new Double[this.size_];
        for (int i = 0; i < this.size_; ++i) {
            this.array_[i] = arrayReal.array_[i];
        }
    }

    @Override
    public Variable deepCopy() {
        return new ArrayReal(this);
    }

    public int getLength() {
        return this.size_;
    }

    public double getValue(int index) throws JMException {
        if (index >= 0 && index < this.size_) {
            return this.array_[index];
        }
        Configuration.logger_.severe("jmetal.base.variable.ArrayReal.getValue: index value (" + index + ") invalid");
        throw new JMException("jmetal.base.variable.ArrayReal: index value (" + index + ") invalid");
    }

    public void setValue(int index, double value) throws JMException {
        if (index < 0 || index >= this.size_) {
            Configuration.logger_.severe("jmetal.base.variable.ArrayReal.setValue: index value (" + index + ") invalid");
            throw new JMException("jmetal.base.variable.ArrayReal: index value (" + index + ") invalid");
        }
        this.array_[index] = value;
    }

    public double getLowerBound(int index) throws JMException {
        if (index >= 0 && index < this.size_) {
            return this.problem_.getLowerLimit(index);
        }
        Configuration.logger_.severe("jmetal.base.variable.ArrayReal.getLowerBound: index value (" + index + ") invalid");
        throw new JMException("jmetal.base.variable.getLowerBound: index value (" + index + ") invalid");
    }

    public double getUpperBound(int index) throws JMException {
        if (index >= 0 && index < this.size_) {
            return this.problem_.getUpperLimit(index);
        }
        Configuration.logger_.severe("jmetal.base.variable.ArrayReal.getUpperBound: index value (" + index + ") invalid");
        throw new JMException("jmetal.base.variable.getUpperBound: index value (" + index + ") invalid");
    }

    public String toString() {
        String string = "";
        for (int i = 0; i < this.size_ - 1; ++i) {
            string = string + this.array_[i] + " ";
        }
        string = string + this.array_[this.size_ - 1];
        return string;
    }
}

