/*
 * Decompiled with CFR 0.152.
 */
package jmetal.encodings.variable;

import java.util.BitSet;
import jmetal.core.Variable;
import jmetal.util.PseudoRandom;

public class Binary
extends Variable {
    public BitSet bits_;
    protected int numberOfBits_;

    public Binary() {
    }

    public Binary(int numberOfBits) {
        this.numberOfBits_ = numberOfBits;
        this.bits_ = new BitSet(this.numberOfBits_);
        for (int i = 0; i < this.numberOfBits_; ++i) {
            if (PseudoRandom.randDouble() < 0.5) {
                this.bits_.set(i, true);
                continue;
            }
            this.bits_.set(i, false);
        }
    }

    public Binary(Binary variable) {
        this.numberOfBits_ = variable.numberOfBits_;
        this.bits_ = new BitSet(this.numberOfBits_);
        for (int i = 0; i < this.numberOfBits_; ++i) {
            this.bits_.set(i, variable.bits_.get(i));
        }
    }

    public void decode() {
    }

    @Override
    public Variable deepCopy() {
        return new Binary(this);
    }

    public int getNumberOfBits() {
        return this.numberOfBits_;
    }

    public boolean getIth(int bit) {
        return this.bits_.get(bit);
    }

    public void setIth(int bit, boolean value) {
        this.bits_.set(bit, value);
    }

    public int hammingDistance(Binary other) {
        int distance = 0;
        for (int i = 0; i < this.bits_.size(); ++i) {
            if (this.bits_.get(i) == other.bits_.get(i)) continue;
            ++distance;
        }
        return distance;
    }

    public String toString() {
        String result = "";
        for (int i = 0; i < this.numberOfBits_; ++i) {
            result = this.bits_.get(i) ? result + "1" : result + "0";
        }
        return result;
    }
}

