/*
 * Decompiled with CFR 0.152.
 */
package jmetal.encodings.variable;

import java.util.ArrayList;
import java.util.Collections;
import jmetal.core.Variable;

public class Permutation
extends Variable {
    public int[] vector_;
    public int size_;

    public Permutation() {
        this.size_ = 0;
        this.vector_ = null;
    }

    public Permutation(int size) {
        this.size_ = size;
        this.vector_ = new int[this.size_];
        ArrayList<Integer> randomSequence = new ArrayList<Integer>(this.size_);
        for (int i = 0; i < this.size_; ++i) {
            randomSequence.add(i);
        }
        Collections.shuffle(randomSequence);
        for (int j = 0; j < randomSequence.size(); ++j) {
            this.vector_[j] = (Integer)randomSequence.get(j);
        }
    }

    public Permutation(Permutation permutation) {
        this.size_ = permutation.size_;
        this.vector_ = new int[this.size_];
        for (int i = 0; i < this.size_; ++i) {
            this.vector_[i] = permutation.vector_[i];
        }
    }

    @Override
    public Variable deepCopy() {
        return new Permutation(this);
    }

    public int getLength() {
        return this.size_;
    }

    public String toString() {
        String string = "";
        for (int i = 0; i < this.size_; ++i) {
            string = string + this.vector_[i] + " ";
        }
        return string;
    }
}

