/*
 * Decompiled with CFR 0.152.
 */
package jmetal.encodings.variable;

import jmetal.core.Variable;
import jmetal.util.Configuration;
import jmetal.util.JMException;
import jmetal.util.PseudoRandom;

public class Real
extends Variable {
    private double value_;
    private double lowerBound_;
    private double upperBound_;

    public Real() {
    }

    public Real(double lowerBound, double upperBound) {
        this.lowerBound_ = lowerBound;
        this.upperBound_ = upperBound;
        this.value_ = PseudoRandom.randDouble() * (upperBound - lowerBound) + lowerBound;
    }

    public Real(Variable variable) throws JMException {
        this.lowerBound_ = variable.getLowerBound();
        this.upperBound_ = variable.getUpperBound();
        this.value_ = variable.getValue();
    }

    @Override
    public double getValue() {
        return this.value_;
    }

    @Override
    public void setValue(double value) {
        this.value_ = value;
    }

    @Override
    public Variable deepCopy() {
        try {
            return new Real(this);
        }
        catch (JMException e) {
            Configuration.logger_.severe("Real.deepCopy.execute: JMException");
            return null;
        }
    }

    @Override
    public double getLowerBound() {
        return this.lowerBound_;
    }

    @Override
    public double getUpperBound() {
        return this.upperBound_;
    }

    @Override
    public void setLowerBound(double lowerBound) {
        this.lowerBound_ = lowerBound;
    }

    @Override
    public void setUpperBound(double upperBound) {
        this.upperBound_ = upperBound;
    }

    public String toString() {
        return this.value_ + "";
    }
}

