/*
 * Decompiled with CFR 0.152.
 */
package jmetal.experiments;

import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jmetal.core.Algorithm;
import jmetal.experiments.Experiment;
import jmetal.experiments.Settings;
import jmetal.experiments.settings.AbYSS_Settings;
import jmetal.experiments.settings.MOCell_Settings;
import jmetal.experiments.settings.NSGAII_Settings;
import jmetal.experiments.settings.SPEA2_Settings;
import jmetal.util.JMException;

public class ConstrainedProblemsStudy
extends Experiment {
    @Override
    public void algorithmSettings(String problemName, int problemIndex, Algorithm[] algorithm) throws ClassNotFoundException {
        try {
            int i;
            int numberOfAlgorithms = this.algorithmNameList_.length;
            HashMap[] parameters = new HashMap[numberOfAlgorithms];
            for (i = 0; i < numberOfAlgorithms; ++i) {
                parameters[i] = new HashMap();
            }
            if (!this.paretoFrontFile_[problemIndex].equals("")) {
                for (i = 0; i < numberOfAlgorithms; ++i) {
                    parameters[i].put("paretoFrontFile_", this.paretoFrontFile_[problemIndex]);
                }
            }
            algorithm[0] = new NSGAII_Settings(problemName).configure(parameters[0]);
            algorithm[1] = new SPEA2_Settings(problemName).configure(parameters[1]);
            algorithm[2] = new MOCell_Settings(problemName).configure(parameters[2]);
            algorithm[3] = new AbYSS_Settings(problemName).configure(parameters[3]);
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(ConstrainedProblemsStudy.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(ConstrainedProblemsStudy.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (JMException ex) {
            Logger.getLogger(ConstrainedProblemsStudy.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void main(String[] args) throws JMException, IOException {
        ConstrainedProblemsStudy exp = new ConstrainedProblemsStudy();
        exp.experimentName_ = "ConstrainedProblemsStudy";
        exp.algorithmNameList_ = new String[]{"NSGAII", "SPEA2", "MOCell", "AbYSS"};
        exp.problemList_ = new String[]{"Golinski", "Srinivas", "Tanaka", "Osyczka2"};
        exp.paretoFrontFile_ = new String[]{"Golinski.pf", "Srinivas.pf", "Tanaka.pf", "Osyczka2.pf"};
        exp.indicatorList_ = new String[]{"EPSILON", "SPREAD", "HV"};
        int numberOfAlgorithms = exp.algorithmNameList_.length;
        exp.experimentBaseDirectory_ = "/Users/antonio/Softw/pruebas/" + exp.experimentName_;
        exp.paretoFrontDirectory_ = "/Users/antonio/Softw/pruebas/data/paretoFronts";
        exp.algorithmSettings_ = new Settings[numberOfAlgorithms];
        exp.independentRuns_ = 100;
        int numberOfThreads = 4;
        exp.runExperiment(4);
        exp.generateLatexTables();
        int rows = 2;
        int columns = 2;
        String prefix = new String("Constrained");
        String[] problems = new String[]{"Golinski", "Srinivas", "Tanaka", "Osyczka2"};
        boolean notch = false;
        exp.generateRBoxplotScripts(rows, columns, problems, prefix, false, exp);
        exp.generateRWilcoxonScripts(problems, prefix, exp);
    }
}

