/*
 * Decompiled with CFR 0.152.
 */
package jmetal.experiments;

import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jmetal.core.Algorithm;
import jmetal.experiments.Experiment;
import jmetal.experiments.Settings;
import jmetal.experiments.settings.NSGAII_Settings;
import jmetal.util.JMException;

public class NSGAIIStudy
extends Experiment {
    @Override
    public synchronized void algorithmSettings(String problemName, int problemIndex, Algorithm[] algorithm) throws ClassNotFoundException {
        try {
            int i;
            int numberOfAlgorithms = this.algorithmNameList_.length;
            HashMap[] parameters = new HashMap[numberOfAlgorithms];
            for (i = 0; i < numberOfAlgorithms; ++i) {
                parameters[i] = new HashMap();
            }
            parameters[0].put("crossoverProbability_", 1.0);
            parameters[1].put("crossoverProbability_", 0.9);
            parameters[2].put("crossoverProbability_", 0.8);
            parameters[3].put("crossoverProbability_", 0.7);
            if (!this.paretoFrontFile_[problemIndex].equals("") || this.paretoFrontFile_[problemIndex] == null) {
                for (i = 0; i < numberOfAlgorithms; ++i) {
                    parameters[i].put("paretoFrontFile_", this.paretoFrontFile_[problemIndex]);
                }
            }
            for (i = 0; i < numberOfAlgorithms; ++i) {
                algorithm[i] = new NSGAII_Settings(problemName).configure(parameters[i]);
            }
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(NSGAIIStudy.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(NSGAIIStudy.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (JMException ex) {
            Logger.getLogger(NSGAIIStudy.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void main(String[] args) throws JMException, IOException {
        NSGAIIStudy exp = new NSGAIIStudy();
        exp.experimentName_ = "NSGAIIStudy";
        exp.algorithmNameList_ = new String[]{"NSGAIIa", "NSGAIIb", "NSGAIIc", "NSGAIId"};
        exp.problemList_ = new String[]{"ZDT1", "ZDT2", "ZDT3", "ZDT4", "DTLZ1", "WFG2"};
        exp.paretoFrontFile_ = new String[]{"ZDT1.pf", "ZDT2.pf", "ZDT3.pf", "ZDT4.pf", "DTLZ1.2D.pf", "WFG2.2D.pf"};
        exp.indicatorList_ = new String[]{"HV", "SPREAD", "IGD", "EPSILON"};
        int numberOfAlgorithms = exp.algorithmNameList_.length;
        exp.experimentBaseDirectory_ = "/Users/antonio/Softw/pruebas/jmetal/" + exp.experimentName_;
        exp.paretoFrontDirectory_ = "/Users/antonio/Softw/pruebas/data/paretoFronts";
        exp.algorithmSettings_ = new Settings[numberOfAlgorithms];
        exp.independentRuns_ = 30;
        int numberOfThreads = 8;
        exp.runExperiment(8);
        exp.generateLatexTables();
        int rows = 2;
        int columns = 3;
        String prefix = new String("Problems");
        String[] problems = new String[]{"ZDT1", "ZDT2", "ZDT3", "ZDT4", "DTLZ1", "WFG2"};
        boolean notch = true;
        exp.generateRBoxplotScripts(rows, columns, problems, prefix, true, exp);
        exp.generateRWilcoxonScripts(problems, prefix, exp);
    }
}

