/*
 * Decompiled with CFR 0.152.
 */
package jmetal.experiments;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.HashMap;
import jmetal.core.Algorithm;
import jmetal.core.Operator;
import jmetal.core.Problem;
import jmetal.encodings.solutionType.ArrayRealSolutionType;
import jmetal.encodings.solutionType.BinaryRealSolutionType;
import jmetal.encodings.solutionType.BinarySolutionType;
import jmetal.encodings.solutionType.RealSolutionType;
import jmetal.operators.crossover.Crossover;
import jmetal.operators.crossover.CrossoverFactory;
import jmetal.operators.mutation.Mutation;
import jmetal.operators.mutation.MutationFactory;
import jmetal.util.JMException;

public abstract class Settings {
    protected Problem problem_;
    protected String problemName_;
    protected String paretoFrontFile_;

    public Settings() {
    }

    public Settings(String problemName) {
        this.problemName_ = problemName;
    }

    public abstract Algorithm configure() throws JMException;

    public final Algorithm configure(HashMap settings) throws JMException, IllegalArgumentException, IllegalAccessException, ClassNotFoundException {
        if (settings != null) {
            int i;
            Field[] fields = this.getClass().getFields();
            for (i = 0; i < fields.length; ++i) {
                Serializable value;
                if (!fields[i].getName().endsWith("_")) continue;
                if (fields[i].getType().equals(Integer.TYPE) || fields[i].getType().equals(Integer.class)) {
                    if (!settings.containsKey(fields[i].getName())) continue;
                    value = (Integer)settings.get(fields[i].getName());
                    fields[i].setInt(this, (int)value);
                    continue;
                }
                if (fields[i].getType().equals(Double.TYPE) || fields[i].getType().equals(Double.class)) {
                    value = (Double)settings.get(fields[i].getName());
                    if (!settings.containsKey(fields[i].getName())) continue;
                    if (fields[i].getName().equals("mutationProbability_") && value == null) {
                        if (this.problem_.getSolutionType().getClass() == RealSolutionType.class || this.problem_.getSolutionType().getClass() == ArrayRealSolutionType.class) {
                            value = 1.0 / (double)this.problem_.getNumberOfVariables();
                        } else if (this.problem_.getSolutionType().getClass() == BinarySolutionType.class || this.problem_.getSolutionType().getClass() == BinaryRealSolutionType.class) {
                            int length = this.problem_.getNumberOfBits();
                            value = 1.0 / (double)length;
                        } else {
                            int length = 0;
                            for (int j = 0; j < this.problem_.getNumberOfVariables(); ++j) {
                                length += this.problem_.getLength(j);
                            }
                            value = 1.0 / (double)length;
                        }
                        fields[i].setDouble(this, (Double)value);
                        continue;
                    }
                    fields[i].setDouble(this, (Double)value);
                    continue;
                }
                value = settings.get(fields[i].getName());
                if (value == null) continue;
                if (fields[i].getType().equals(Crossover.class)) {
                    Crossover value2 = CrossoverFactory.getCrossoverOperator((String)((Object)value), settings);
                    value = value2;
                }
                if (fields[i].getType().equals(Mutation.class)) {
                    Mutation value2 = MutationFactory.getMutationOperator((String)((Object)value), settings);
                    value = value2;
                }
                fields[i].set(this, value);
            }
            for (i = 0; i < fields.length; ++i) {
                if (!fields[i].getType().equals(Crossover.class) && !fields[i].getType().equals(Mutation.class)) continue;
                Operator operator = (Operator)fields[i].get(this);
                String tmp = fields[i].getName();
                String aux = fields[i].getName().substring(0, tmp.length() - 1);
                for (int j = 0; j < fields.length; ++j) {
                    if (i == j || !fields[j].getName().startsWith(aux)) continue;
                    tmp = fields[j].getName().substring(aux.length(), fields[j].getName().length() - 1);
                    if (fields[j].get(this) == null) continue;
                    if (fields[j].getType().equals(Integer.TYPE) || fields[j].getType().equals(Integer.class)) {
                        operator.setParameter(tmp, fields[j].getInt(this));
                        continue;
                    }
                    if (!fields[j].getType().equals(Double.TYPE) && !fields[j].getType().equals(Double.class)) continue;
                    operator.setParameter(tmp, fields[j].getDouble(this));
                }
            }
            this.paretoFrontFile_ = (String)settings.get("paretoFrontFile_");
        }
        return this.configure();
    }

    void setProblem(Problem problem) {
        this.problem_ = problem;
    }

    Problem getProblem() {
        return this.problem_;
    }
}

