/*
 * Decompiled with CFR 0.152.
 */
package jmetal.experiments;

import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jmetal.core.Algorithm;
import jmetal.experiments.Experiment;
import jmetal.experiments.Settings;
import jmetal.experiments.settings.GDE3_Settings;
import jmetal.experiments.settings.MOCell_Settings;
import jmetal.experiments.settings.NSGAII_Settings;
import jmetal.experiments.settings.SMPSO_Settings;
import jmetal.experiments.settings.SPEA2_Settings;
import jmetal.util.JMException;

public class StandardStudy2
extends Experiment {
    @Override
    public void algorithmSettings(String problemName, int problemIndex, Algorithm[] algorithm) throws ClassNotFoundException {
        try {
            int i;
            int numberOfAlgorithms = this.algorithmNameList_.length;
            HashMap[] parameters = new HashMap[numberOfAlgorithms];
            for (i = 0; i < numberOfAlgorithms; ++i) {
                parameters[i] = new HashMap();
            }
            if (!this.paretoFrontFile_[problemIndex].equals("")) {
                for (i = 0; i < numberOfAlgorithms; ++i) {
                    parameters[i].put("paretoFrontFile_", this.paretoFrontFile_[problemIndex]);
                }
            }
            algorithm[0] = new NSGAII_Settings(problemName).configure(parameters[0]);
            algorithm[1] = new SPEA2_Settings(problemName).configure(parameters[1]);
            algorithm[2] = new MOCell_Settings(problemName).configure(parameters[2]);
            algorithm[3] = new SMPSO_Settings(problemName).configure(parameters[3]);
            algorithm[4] = new GDE3_Settings(problemName).configure(parameters[4]);
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(StandardStudy2.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(StandardStudy2.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (JMException ex) {
            Logger.getLogger(StandardStudy2.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void main(String[] args) throws JMException, IOException {
        StandardStudy2 exp = new StandardStudy2();
        exp.experimentName_ = "StandardStudy";
        exp.algorithmNameList_ = new String[]{"NSGAII", "SPEA2", "MOCell", "SMPSO", "GDE3"};
        exp.problemList_ = new String[]{"ZDT1", "ZDT2", "ZDT3", "ZDT4", "ZDT6", "WFG1", "WFG2", "WFG3", "WFG4", "WFG5", "WFG6", "WFG7", "WFG8", "WFG9", "DTLZ1", "DTLZ2", "DTLZ3", "DTLZ4", "DTLZ5", "DTLZ6", "DTLZ7"};
        exp.paretoFrontFile_ = new String[18];
        exp.indicatorList_ = new String[]{"HV", "SPREAD", "EPSILON"};
        int numberOfAlgorithms = exp.algorithmNameList_.length;
        exp.experimentBaseDirectory_ = "/Users/antonio/Softw/pruebas/jmetal/" + exp.experimentName_;
        exp.paretoFrontDirectory_ = "";
        exp.algorithmSettings_ = new Settings[numberOfAlgorithms];
        exp.independentRuns_ = 100;
        int numberOfThreads = 4;
        exp.runExperiment(4);
        exp.generateLatexTables();
        int rows = 3;
        int columns = 2;
        String prefix = new String("ZDT");
        String[] problems = new String[]{"ZDT1", "ZDT2", "ZDT3", "ZDT4", "ZDT6"};
        boolean notch = false;
        exp.generateRBoxplotScripts(rows, columns, problems, prefix, false, exp);
        exp.generateRWilcoxonScripts(problems, prefix, exp);
        rows = 3;
        columns = 3;
        prefix = new String("DTLZ");
        problems = new String[]{"DTLZ1", "DTLZ2", "DTLZ3", "DTLZ4", "DTLZ5", "DTLZ6", "DTLZ7"};
        notch = false;
        exp.generateRBoxplotScripts(rows, columns, problems, prefix, false, exp);
        exp.generateRWilcoxonScripts(problems, prefix, exp);
        rows = 3;
        columns = 3;
        prefix = new String("WFG");
        problems = new String[]{"WFG1", "WFG2", "WFG3", "WFG4", "WFG5", "WFG6", "WFG7", "WFG8", "WFG9"};
        notch = false;
        exp.generateRBoxplotScripts(rows, columns, problems, prefix, false, exp);
        exp.generateRWilcoxonScripts(problems, prefix, exp);
    }
}

