/*
 * Decompiled with CFR 0.152.
 */
package jmetal.experiments;

import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jmetal.core.Algorithm;
import jmetal.experiments.Experiment;
import jmetal.experiments.Settings;
import jmetal.experiments.StandardStudy;
import jmetal.experiments.settings.AbYSS_Settings;
import jmetal.experiments.settings.GDE3_Settings;
import jmetal.experiments.settings.NSGAII_Settings;
import jmetal.experiments.settings.SMPSO_Settings;
import jmetal.util.JMException;

public class ZDTStudy2
extends Experiment {
    @Override
    public void algorithmSettings(String problemName, int problemIndex, Algorithm[] algorithm) throws ClassNotFoundException {
        try {
            int i;
            int numberOfAlgorithms = this.algorithmNameList_.length;
            HashMap[] parameters = new HashMap[numberOfAlgorithms];
            for (i = 0; i < numberOfAlgorithms; ++i) {
                parameters[i] = new HashMap();
            }
            if (this.paretoFrontFile_[problemIndex] != null && !this.paretoFrontFile_[problemIndex].equals("")) {
                for (i = 0; i < numberOfAlgorithms; ++i) {
                    parameters[i].put("frontPath_", this.frontPath_[problemIndex]);
                }
            }
            algorithm[0] = new NSGAII_Settings(problemName).configure(parameters[0]);
            algorithm[1] = new SMPSO_Settings(problemName).configure(parameters[1]);
            algorithm[2] = new GDE3_Settings(problemName).configure(parameters[2]);
            algorithm[3] = new AbYSS_Settings(problemName).configure(parameters[3]);
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(StandardStudy.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(StandardStudy.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (JMException ex) {
            Logger.getLogger(StandardStudy.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void main(String[] args) throws JMException, IOException {
        ZDTStudy2 exp = new ZDTStudy2();
        exp.experimentName_ = "ZDTStudy2";
        exp.algorithmNameList_ = new String[]{"NSGAII", "SMPSO", "GDE3", "AbySS"};
        exp.problemList_ = new String[]{"ZDT1", "ZDT2", "ZDT3", "ZDT4", "ZDT6"};
        exp.paretoFrontFile_ = new String[7];
        exp.indicatorList_ = new String[]{"HV", "SPREAD", "EPSILON"};
        int numberOfAlgorithms = exp.algorithmNameList_.length;
        exp.experimentBaseDirectory_ = "/Users/antelverde/Softw/pruebas/jmetal/" + exp.experimentName_;
        exp.paretoFrontDirectory_ = "";
        exp.algorithmSettings_ = new Settings[numberOfAlgorithms];
        exp.independentRuns_ = 20;
        int numberOfThreads = 7;
        exp.runExperiment(7);
        exp.generateLatexTables();
        int rows = 3;
        int columns = 3;
        String prefix = new String("ZDT");
        String[] problems = new String[]{"ZDT1", "ZDT2", "ZDT3", "ZDT4", "ZDT6"};
        boolean notch = false;
        exp.generateRBoxplotScripts(rows, columns, problems, prefix, false, exp);
        exp.generateRWilcoxonScripts(problems, prefix, exp);
    }
}

