/*
 * Decompiled with CFR 0.152.
 */
package jmetal.experiments.settings;

import java.util.HashMap;
import jmetal.core.Algorithm;
import jmetal.experiments.Settings;
import jmetal.metaheuristics.abyss.AbYSS;
import jmetal.operators.crossover.Crossover;
import jmetal.operators.crossover.CrossoverFactory;
import jmetal.operators.localSearch.MutationLocalSearch;
import jmetal.operators.mutation.Mutation;
import jmetal.operators.mutation.MutationFactory;
import jmetal.problems.ProblemFactory;
import jmetal.util.JMException;

public class AbYSS_Settings
extends Settings {
    public int populationSize_;
    public int maxEvaluations_;
    public int archiveSize_;
    public int refSet1Size_;
    public int refSet2Size_;
    public double mutationProbability_;
    public double crossoverProbability_;
    public double crossoverDistributionIndex_;
    public double mutationDistributionIndex_;
    public int improvementRounds_;

    public AbYSS_Settings(String problemName) {
        super(problemName);
        Object[] problemParams = new Object[]{"Real"};
        try {
            this.problem_ = new ProblemFactory().getProblem(this.problemName_, problemParams);
        }
        catch (JMException e) {
            e.printStackTrace();
        }
        this.populationSize_ = 20;
        this.maxEvaluations_ = 25000;
        this.archiveSize_ = 100;
        this.refSet1Size_ = 10;
        this.refSet2Size_ = 10;
        this.mutationProbability_ = 1.0 / (double)this.problem_.getNumberOfVariables();
        this.crossoverProbability_ = 1.0;
        this.crossoverDistributionIndex_ = 20.0;
        this.mutationDistributionIndex_ = 20.0;
        this.improvementRounds_ = 1;
    }

    @Override
    public Algorithm configure() throws JMException {
        AbYSS algorithm = new AbYSS(this.problem_);
        algorithm.setInputParameter("populationSize", this.populationSize_);
        algorithm.setInputParameter("refSet1Size", this.refSet1Size_);
        algorithm.setInputParameter("refSet2Size", this.refSet2Size_);
        algorithm.setInputParameter("archiveSize", this.archiveSize_);
        algorithm.setInputParameter("maxEvaluations", this.maxEvaluations_);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("probability", this.crossoverProbability_);
        parameters.put("distributionIndex", this.crossoverDistributionIndex_);
        Crossover crossover = CrossoverFactory.getCrossoverOperator("SBXCrossover", parameters);
        parameters = new HashMap();
        parameters.put("probability", this.mutationProbability_);
        parameters.put("distributionIndex", this.mutationDistributionIndex_);
        Mutation mutation = MutationFactory.getMutationOperator("PolynomialMutation", parameters);
        parameters = new HashMap();
        parameters.put("improvementRounds", 1);
        parameters.put("problem", this.problem_);
        parameters.put("mutation", mutation);
        MutationLocalSearch improvement = new MutationLocalSearch(parameters);
        algorithm.addOperator("crossover", crossover);
        algorithm.addOperator("improvement", improvement);
        return algorithm;
    }
}

