/*
 * Decompiled with CFR 0.152.
 */
package jmetal.experiments.settings;

import java.util.HashMap;
import jmetal.core.Algorithm;
import jmetal.experiments.Settings;
import jmetal.metaheuristics.gde3.GDE3;
import jmetal.operators.crossover.Crossover;
import jmetal.operators.crossover.CrossoverFactory;
import jmetal.operators.selection.Selection;
import jmetal.operators.selection.SelectionFactory;
import jmetal.problems.ProblemFactory;
import jmetal.util.JMException;

public class GDE3_Settings
extends Settings {
    public double CR_;
    public double F_;
    public int populationSize_;
    public int maxIterations_;

    public GDE3_Settings(String problemName) {
        super(problemName);
        Object[] problemParams = new Object[]{"Real"};
        try {
            this.problem_ = new ProblemFactory().getProblem(this.problemName_, problemParams);
        }
        catch (JMException e) {
            e.printStackTrace();
        }
        this.CR_ = 0.5;
        this.F_ = 0.5;
        this.populationSize_ = 100;
        this.maxIterations_ = 250;
    }

    @Override
    public Algorithm configure() throws JMException {
        Object[] problemParams = new Object[]{"Real"};
        this.problem_ = new ProblemFactory().getProblem(this.problemName_, problemParams);
        GDE3 algorithm = new GDE3(this.problem_);
        algorithm.setInputParameter("populationSize", this.populationSize_);
        algorithm.setInputParameter("maxIterations", this.maxIterations_);
        HashMap<String, Double> parameters = new HashMap<String, Double>();
        parameters.put("CR", this.CR_);
        parameters.put("F", this.F_);
        Crossover crossover = CrossoverFactory.getCrossoverOperator("DifferentialEvolutionCrossover", parameters);
        parameters = null;
        Selection selection = SelectionFactory.getSelectionOperator("DifferentialEvolutionSelection", parameters);
        algorithm.addOperator("crossover", crossover);
        algorithm.addOperator("selection", selection);
        return algorithm;
    }
}

