/*
 * Decompiled with CFR 0.152.
 */
package jmetal.experiments.settings;

import java.util.HashMap;
import jmetal.core.Algorithm;
import jmetal.experiments.Settings;
import jmetal.metaheuristics.ibea.IBEA;
import jmetal.operators.crossover.Crossover;
import jmetal.operators.crossover.CrossoverFactory;
import jmetal.operators.mutation.Mutation;
import jmetal.operators.mutation.MutationFactory;
import jmetal.operators.selection.BinaryTournament;
import jmetal.problems.ProblemFactory;
import jmetal.util.JMException;
import jmetal.util.comparators.FitnessComparator;

public class IBEA_Settings
extends Settings {
    public int populationSize_;
    public int maxEvaluations_;
    public int archiveSize_;
    public double mutationProbability_;
    public double crossoverProbability_;
    public double crossoverDistributionIndex_;
    public double mutationDistributionIndex_;

    public IBEA_Settings(String problemName) {
        super(problemName);
        Object[] problemParams = new Object[]{"Real"};
        try {
            this.problem_ = new ProblemFactory().getProblem(this.problemName_, problemParams);
        }
        catch (JMException e) {
            e.printStackTrace();
        }
        this.populationSize_ = 100;
        this.maxEvaluations_ = 25000;
        this.archiveSize_ = 100;
        this.mutationProbability_ = 1.0 / (double)this.problem_.getNumberOfVariables();
        this.crossoverProbability_ = 0.9;
        this.crossoverDistributionIndex_ = 20.0;
        this.mutationDistributionIndex_ = 20.0;
    }

    @Override
    public Algorithm configure() throws JMException {
        Object[] problemParams = new Object[]{"Real"};
        this.problem_ = new ProblemFactory().getProblem(this.problemName_, problemParams);
        IBEA algorithm = new IBEA(this.problem_);
        algorithm.setInputParameter("populationSize", this.populationSize_);
        algorithm.setInputParameter("maxEvaluations", this.maxEvaluations_);
        algorithm.setInputParameter("archiveSize", this.archiveSize_);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("probability", this.crossoverProbability_);
        parameters.put("distributionIndex", this.crossoverDistributionIndex_);
        Crossover crossover = CrossoverFactory.getCrossoverOperator("SBXCrossover", parameters);
        parameters = new HashMap();
        parameters.put("probability", this.mutationProbability_);
        parameters.put("distributionIndex", this.mutationDistributionIndex_);
        Mutation mutation = MutationFactory.getMutationOperator("PolynomialMutation", parameters);
        parameters = new HashMap();
        parameters.put("comparator", new FitnessComparator());
        BinaryTournament selection = new BinaryTournament(parameters);
        algorithm.addOperator("crossover", crossover);
        algorithm.addOperator("mutation", mutation);
        algorithm.addOperator("selection", selection);
        return algorithm;
    }
}

