/*
 * Decompiled with CFR 0.152.
 */
package jmetal.experiments.settings;

import java.util.HashMap;
import jmetal.core.Algorithm;
import jmetal.experiments.Settings;
import jmetal.metaheuristics.moead.MOEAD_DRA;
import jmetal.operators.crossover.Crossover;
import jmetal.operators.crossover.CrossoverFactory;
import jmetal.operators.mutation.Mutation;
import jmetal.operators.mutation.MutationFactory;
import jmetal.problems.ProblemFactory;
import jmetal.util.JMException;

public class MOEAD_DRA_Settings
extends Settings {
    public double CR_;
    public double F_;
    public int populationSize_;
    public int maxEvaluations_;
    public int finalSize_;
    public double mutationProbability_;
    public double distributionIndexForMutation_;
    public String dataDirectory_;
    public int numberOfThreads;
    public String moeadVersion;

    public MOEAD_DRA_Settings(String problem) {
        super(problem);
        Object[] problemParams = new Object[]{"Real"};
        try {
            this.problem_ = new ProblemFactory().getProblem(this.problemName_, problemParams);
        }
        catch (JMException e) {
            e.printStackTrace();
        }
        this.CR_ = 1.0;
        this.F_ = 0.5;
        this.populationSize_ = 600;
        this.maxEvaluations_ = 150000;
        this.finalSize_ = 600;
        this.mutationProbability_ = 1.0 / (double)this.problem_.getNumberOfVariables();
        this.distributionIndexForMutation_ = 20.0;
        this.dataDirectory_ = "/Users/antelverde/Dropbox/jMetal/data/MOEAD_parameters/Weight";
        this.numberOfThreads = 2;
        this.moeadVersion = "MOEAD_DRA";
    }

    @Override
    public Algorithm configure() throws JMException {
        MOEAD_DRA algorithm = new MOEAD_DRA(this.problem_);
        algorithm.setInputParameter("populationSize", this.populationSize_);
        algorithm.setInputParameter("maxEvaluations", this.maxEvaluations_);
        algorithm.setInputParameter("dataDirectory", this.dataDirectory_);
        algorithm.setInputParameter("finalSize", this.finalSize_);
        HashMap<String, Double> parameters = new HashMap<String, Double>();
        parameters.put("CR", this.CR_);
        parameters.put("F", this.F_);
        Crossover crossover = CrossoverFactory.getCrossoverOperator("DifferentialEvolutionCrossover", parameters);
        parameters = new HashMap();
        parameters.put("probability", 1.0 / (double)this.problem_.getNumberOfVariables());
        parameters.put("distributionIndex", this.distributionIndexForMutation_);
        Mutation mutation = MutationFactory.getMutationOperator("PolynomialMutation", parameters);
        algorithm.addOperator("crossover", crossover);
        algorithm.addOperator("mutation", mutation);
        return algorithm;
    }
}

